/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.util.Optional;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.simplify4u.plugins.keysmap.KeyInfoItem;
import org.simplify4u.plugins.utils.PublicKeyUtils;

public class KeyInfoItemKey
implements KeyInfoItem {
    private final byte[] fingerPrint;

    public KeyInfoItemKey(String key) {
        this.fingerPrint = KeyInfoItemKey.strKeyToBytes(key);
    }

    @Override
    public boolean isKeyMatch(PGPPublicKey pgpPublicKey, PGPPublicKeyRing pgpPublicKeyRing) {
        if (KeyInfoItemKey.compareArrays(this.fingerPrint, pgpPublicKey.getFingerprint())) {
            return true;
        }
        Optional<PGPPublicKey> masterKey = PublicKeyUtils.getMasterKey(pgpPublicKey, pgpPublicKeyRing);
        return masterKey.filter(publicKey -> this.isKeyMatch((PGPPublicKey)publicKey, pgpPublicKeyRing)).isPresent();
    }

    private static byte[] strKeyToBytes(String key) {
        byte[] bytes;
        try {
            bytes = Hex.decode((String)key.substring(2));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Malformed keyID hex string " + key, e);
        }
        if (bytes.length < 8 || bytes.length > 20) {
            throw new IllegalArgumentException(String.format("Key length for = %s is %d bits, should be between 64 and 160 bits", key, bytes.length * 8));
        }
        return bytes;
    }

    private static boolean compareArrays(byte[] keyBytes, byte[] fingerprint) {
        for (int i = 1; i <= keyBytes.length && i <= fingerprint.length; ++i) {
            if (keyBytes[keyBytes.length - i] == fingerprint[fingerprint.length - i]) continue;
            return false;
        }
        return true;
    }
}

