/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.simplify4u.plugins.utils.HexUtils;

public interface PGPKeyId {
    public String getHashPath();

    public PGPPublicKey getKeyFromRing(PGPPublicKeyRing var1);

    public PGPPublicKeyRing getKeyRingFromRingCollection(PGPPublicKeyRingCollection var1) throws PGPException;

    public static PGPKeyId from(byte[] fingerprint) {
        return new PGPKeyIdFingerprint(fingerprint);
    }

    public static PGPKeyId from(Long keyId) {
        return new PGPKeyIdLong(keyId);
    }

    public static class PGPKeyIdFingerprint
    implements PGPKeyId {
        private final byte[] fingerprint;

        PGPKeyIdFingerprint(byte[] fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public String getHashPath() {
            StringBuilder ret = new StringBuilder();
            ret.append(String.format("%02X/", this.fingerprint[0]));
            ret.append(String.format("%02X/", this.fingerprint[1]));
            for (byte b : this.fingerprint) {
                ret.append(String.format("%02X", b));
            }
            ret.append(".asc");
            return ret.toString();
        }

        @Override
        public PGPPublicKey getKeyFromRing(PGPPublicKeyRing publicKeyRing) {
            return publicKeyRing.getPublicKey(this.fingerprint);
        }

        @Override
        public PGPPublicKeyRing getKeyRingFromRingCollection(PGPPublicKeyRingCollection pgpRingCollection) throws PGPException {
            return pgpRingCollection.getPublicKeyRing(this.fingerprint);
        }

        public String toString() {
            return HexUtils.fingerprintToString(this.fingerprint);
        }
    }

    public static class PGPKeyIdLong
    implements PGPKeyId {
        private final Long keyId;

        PGPKeyIdLong(Long keyId) {
            this.keyId = keyId;
        }

        @Override
        public String getHashPath() {
            return String.format("%02X/%02X/%016X.asc", (byte)(this.keyId >> 56), (byte)(this.keyId >> 48 & 0xFFL), this.keyId);
        }

        @Override
        public PGPPublicKey getKeyFromRing(PGPPublicKeyRing publicKeyRing) {
            return publicKeyRing.getPublicKey(this.keyId.longValue());
        }

        @Override
        public PGPPublicKeyRing getKeyRingFromRingCollection(PGPPublicKeyRingCollection pgpRingCollection) throws PGPException {
            return pgpRingCollection.getPublicKeyRing(this.keyId.longValue());
        }

        public String toString() {
            return String.format("0x%016X", this.keyId);
        }
    }
}

