/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.creator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.simplericity.jettyconsole.creator.Creator;
import org.simplericity.jettyconsole.creator.CreatorExecutionException;

public class DefaultCreator
implements Creator {
    private File workingDirectory;
    private File sourceWar;
    private URL backgroundImage;
    private File destinationWar;
    private String consoleDirectory = "META-INF/jettyconsole";
    private String name;
    private List<URL> additionalDependencies;
    private static final String MAIN_CLASS = "org/simplericity/jettyconsole/JettyConsoleBootstrapMainClass";
    private URL coreDependencyUrl;
    private String properties;
    private Map<String, String> manifestEntries;

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setSourceWar(File file) {
        this.sourceWar = file;
    }

    @Override
    public void setBackgroundImage(URL url) {
        this.backgroundImage = url;
    }

    @Override
    public void setDestinationWar(File destinationFile) {
        this.destinationWar = destinationFile;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setCoreDependency(URL coreDependencyUrl) {
        this.coreDependencyUrl = coreDependencyUrl;
    }

    @Override
    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public void setManifestEntries(Map<String, String> manifestEntries) {
        this.manifestEntries = manifestEntries;
    }

    @Override
    public void setAdditionalDependecies(List<URL> additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    @Override
    public void create() throws CreatorExecutionException {
        this.workingDirectory.mkdirs();
        File consoleDir = new File(this.workingDirectory, this.consoleDirectory);
        consoleDir.mkdirs();
        this.writeDescriptor(consoleDir);
        this.extractWar(this.sourceWar);
        this.copyBackgroundImage();
        this.writePathDescriptor(consoleDir, this.copyAdditionalDependencies());
        this.packageConsole();
    }

    private void writePathDescriptor(File consoleDir, Set<String> paths) {
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(new File(consoleDir, "jettyconsolepaths.txt")));){
            for (String path : paths) {
                writer.println(path);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void packageConsole() throws CreatorExecutionException {
        try {
            Jar jarArchiver = new Jar();
            jarArchiver.setProject(new Project());
            jarArchiver.setDestFile(this.destinationWar);
            FileSet fileSet = new FileSet();
            fileSet.setDir(this.workingDirectory);
            jarArchiver.addFileset(fileSet);
            jarArchiver.addConfiguredManifest(this.createManifest());
            jarArchiver.execute();
        }
        catch (ManifestException e) {
            throw new CreatorExecutionException(e.getMessage(), e);
        }
    }

    private Manifest createManifest() throws ManifestException {
        Manifest manifest = new Manifest();
        manifest.addConfiguredAttribute(new Manifest.Attribute("Main-Class", MAIN_CLASS));
        for (Map.Entry<String, String> entry : this.manifestEntries.entrySet()) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(entry.getKey(), entry.getValue()));
        }
        return manifest;
    }

    private Set<String> copyAdditionalDependencies() throws CreatorExecutionException {
        File libDirectory = new File(this.workingDirectory, "META-INF/jettyconsole/lib");
        libDirectory.mkdirs();
        HashSet<String> tldJars = new HashSet<String>();
        ArrayList<String> options = new ArrayList<String>();
        for (URL url : this.additionalDependencies) {
            this.copyIntoLib(url, libDirectory, tldJars, options);
        }
        this.copyIntoLib(this.coreDependencyUrl, libDirectory, tldJars, options);
        this.writeOptions(options);
        this.unpackMainClassAndFilter(this.coreDependencyUrl);
        return tldJars;
    }

    private void writeOptions(List<String> options) {
        File optionsFile = new File(new File(this.workingDirectory, this.consoleDirectory), "options.txt");
        try {
            FileUtils.writeLines((File)optionsFile, (String)"utf-8", options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copyIntoLib(URL url, File libDirectory, Set<String> tldJars, List<String> options) throws CreatorExecutionException {
        String name = url.getPath().substring(url.getPath().lastIndexOf("/"));
        try {
            File file = new File(libDirectory, name);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)url.openStream(), (OutputStream)out);
            out.close();
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().startsWith("META-INF/") && entry.getName().endsWith(".tld")) {
                        tldJars.add(file.getName());
                    }
                    if (!entry.getName().startsWith("META-INF/services") || !entry.getName().endsWith("JettyConsolePlugin/options.txt")) continue;
                    options.add(IOUtils.toString((InputStream)jarFile.getInputStream(entry)));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void unpackMainClassAndFilter(URL coredep) {
        try (JarInputStream in = new JarInputStream(coredep.openStream());){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                if (!entry.getName().startsWith(MAIN_CLASS) || !entry.getName().endsWith(".class")) continue;
                File file = new File(this.workingDirectory, entry.getName());
                file.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copyBackgroundImage() throws CreatorExecutionException {
        try {
            if (this.backgroundImage == null) {
                URL resource = this.getClass().getClassLoader().getResource("default-background-image.jpg");
                this.setBackgroundImage(resource);
            }
            IOUtils.copy((InputStream)this.backgroundImage.openStream(), (OutputStream)new FileOutputStream(new File(new File(this.workingDirectory, "META-INF/jettyconsole"), "background-image.jpg")));
        }
        catch (IOException e) {
            throw new CreatorExecutionException("Cannot copy background image '" + this.backgroundImage + "'", e);
        }
    }

    private void extractWar(File file) throws CreatorExecutionException {
        Project project = new Project();
        Expand unArchiver = new Expand();
        unArchiver.setProject(project);
        unArchiver.setSrc(file);
        unArchiver.setDest(this.workingDirectory);
        unArchiver.execute();
    }

    private void writeDescriptor(File consoleDir) throws CreatorExecutionException {
        block16: {
            try (PrintWriter writer = new PrintWriter(new FileOutputStream(new File(consoleDir, "jettyconsole.properties")));){
                writer.println("name=" + this.name);
                if (this.properties == null || this.properties.trim().length() <= 0) break block16;
                try {
                    Properties p = new Properties();
                    p.load(new ByteArrayInputStream(this.properties.getBytes()));
                    writer.println(this.properties);
                }
                catch (IOException e) {
                    throw new CreatorExecutionException("Can't parse properties: [" + this.properties + "]", e);
                }
            }
            catch (FileNotFoundException e) {
                throw new CreatorExecutionException("Cannot write to descriptor file", e);
            }
        }
    }
}

