/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.rtf;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simplejavamail.outlookmessageparser.rtf.RTF2HTMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRTF2HTMLConverter
implements RTF2HTMLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRTF2HTMLConverter.class);
    private static final String[] HTML_START_TAGS = new String[]{"<html ", "<Html ", "<HTML "};
    private static final String[] HTML_END_TAGS = new String[]{"</html>", "</Html>", "</HTML>"};
    private static final String WINDOWS_CHARSET = "CP1252";

    @Override
    public String rtf2html(String rtf) {
        if (rtf != null) {
            String plain = this.fetchHtmlSection(rtf);
            plain = this.replaceHexSequences(plain);
            plain = this.replaceSpecialSequences(plain);
            plain = this.replaceRemainingControlSequences(plain);
            plain = this.replaceLineBreaks(plain);
            return plain;
        }
        return null;
    }

    private String replaceLineBreaks(String text) {
        String replacedText = text;
        replacedText = replacedText.replaceAll("( <br/> ( <br/> )+)", " <br/> ");
        replacedText = replacedText.replaceAll("[\\n\\r]+", "");
        return replacedText;
    }

    private String replaceHexSequences(String text) {
        Matcher m = Pattern.compile("\\\\'(..)").matcher(text);
        String replacedText = text;
        while (m.find()) {
            for (int g = 1; g <= m.groupCount(); ++g) {
                String hex = m.group(g);
                String hexToString = SimpleRTF2HTMLConverter.hexToString(hex);
                if (hexToString == null) continue;
                replacedText = replacedText.replaceAll("\\\\'" + hex, hexToString);
            }
        }
        return replacedText;
    }

    private String fetchHtmlSection(String text) {
        int i;
        int htmlStart = -1;
        int htmlEnd = -1;
        for (i = 0; i < HTML_START_TAGS.length && htmlStart < 0; ++i) {
            htmlStart = text.indexOf(HTML_START_TAGS[i]);
        }
        for (i = 0; i < HTML_END_TAGS.length && htmlEnd < 0; ++i) {
            htmlEnd = text.indexOf(HTML_END_TAGS[i]);
            if (htmlEnd <= 0) continue;
            htmlEnd += HTML_END_TAGS[i].length();
        }
        if (htmlStart > -1 && htmlEnd > -1) {
            return text.substring(htmlStart, htmlEnd + 1);
        }
        String html = "<html><body style=\"font-family:'Courier',monospace;font-size:10pt;\">" + text + "</body></html>";
        html = html.replaceAll("[\\n\\r]+", " <br/> ");
        html = html.replaceAll("(http://\\S+)", "<a href=\"$1\">$1</a>");
        return html.replaceAll("mailto:(\\S+@\\S+)", "<a href=\"mailto:$1\">$1</a>");
    }

    private String replaceSpecialSequences(String text) {
        String replacedText = text;
        replacedText = replacedText.replaceAll("\\{\\\\S+ [^\\s\\\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{HYPERLINK[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\pntext[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\f\\d+[^\\}]*\\}", "");
        replacedText = replacedText.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+(<.+>)\\}", "$1");
        replacedText = replacedText.replaceAll("\\{\\\\\\*\\\\htmltag\\d+[^\\}<]+\\}", "");
        replacedText = replacedText.replaceAll("([^\\\\])\\}+", "$1");
        replacedText = replacedText.replaceAll("([^\\\\])\\{+", "$1");
        replacedText = replacedText.replaceAll("\\\\\\}", "}");
        replacedText = replacedText.replaceAll("\\\\\\{", "{");
        return replacedText;
    }

    private static String hexToString(String hex) {
        int i;
        try {
            i = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Could not interpret {} as a number.", (Object)hex, (Object)nfe);
            return null;
        }
        try {
            return new String(new byte[]{(byte)i}, WINDOWS_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unsupported encoding: {}", (Object)WINDOWS_CHARSET, (Object)e);
            return null;
        }
    }

    private String replaceRemainingControlSequences(String text) {
        String replacedText = text;
        replacedText = replacedText.replaceAll("\\\\pard*", "\n");
        replacedText = replacedText.replaceAll("\\\\tab", "\t");
        replacedText = replacedText.replaceAll("\\\\\\*\\\\\\S+", "");
        replacedText = replacedText.replaceAll("\\\\\\S+", "");
        return replacedText;
    }
}

