/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.simplejavamail.mailer.internal.socks.SocksProxyConfig;
import org.simplejavamail.mailer.internal.socks.common.Socks5Bridge;
import org.simplejavamail.mailer.internal.socks.socks5client.KeyStoreInfo;
import org.simplejavamail.mailer.internal.socks.socks5client.ProxyCredentials;
import org.simplejavamail.mailer.internal.socks.socks5client.SSLConfiguration;
import org.simplejavamail.mailer.internal.socks.socks5client.SSLSocks5;
import org.simplejavamail.mailer.internal.socks.socks5client.Socks5;
import org.simplejavamail.mailer.internal.socks.socks5client.SocksSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatingSocks5Bridge
implements Socks5Bridge {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"socks5bridge");
    private final SocksProxyConfig proxyConfig;

    public AuthenticatingSocks5Bridge(SocksProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Socket connect(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        return this.proxyConfig.requiresAuthentication() ? this.createSocketAuthenticated(sessionId, remoteServerAddress, remoteServerPort) : this.createSocketPlainAnonymous(sessionId, remoteServerAddress, remoteServerPort);
    }

    private Socket createSocketAuthenticated(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging to remote proxy {}", (Object)sessionId, (Object)this.proxyConfig);
        Socks5 proxyAuth = new Socks5(new InetSocketAddress(this.proxyConfig.remoteProxyHost, (int)this.proxyConfig.remoteProxyPort));
        proxyAuth.setCredentials(new ProxyCredentials(this.proxyConfig.username, this.proxyConfig.password));
        return new SocksSocket(proxyAuth, proxyAuth.createProxySocket(), new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }

    private Socket createSocketPlainAnonymous(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging anonymously to remote proxy {}:{}", new Object[]{sessionId, this.proxyConfig.remoteProxyHost, this.proxyConfig.remoteProxyPort});
        Socks5 socksProxyAnonymous = new Socks5(new InetSocketAddress(this.proxyConfig.remoteProxyHost, (int)this.proxyConfig.remoteProxyPort));
        return new SocksSocket(socksProxyAnonymous, new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }

    private Socket createSocketSSLAuthenticated(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging with SSL to remote proxy {}", (Object)sessionId, (Object)this.proxyConfig);
        SSLSocks5 socksProxySSLAuth = new SSLSocks5(new InetSocketAddress("localhost", this.proxyConfig.proxyBridgePort), new SSLConfiguration(null, new KeyStoreInfo("client-trust-keystore.jks", "123456", "JKS")));
        socksProxySSLAuth.setCredentials(new ProxyCredentials(this.proxyConfig.username, this.proxyConfig.password));
        return new SocksSocket((Socks5)socksProxySSLAuth, new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }

    private Socket createSocketSSL(String sessionId, InetAddress remoteServerAddress, int remoteServerPort) throws IOException {
        LOGGER.info("SESSION[{}] bridging with SSL anonymously to remote proxy {}:{}", new Object[]{sessionId, this.proxyConfig.remoteProxyHost, this.proxyConfig.remoteProxyPort});
        SSLSocks5 socksProxySSLAnonymous = new SSLSocks5(new InetSocketAddress("localhost", this.proxyConfig.proxyBridgePort), new SSLConfiguration(null, new KeyStoreInfo("client-trust-keystore.jks", "123456", "JKS")));
        return new SocksSocket((Socks5)socksProxySSLAnonymous, new InetSocketAddress(remoteServerAddress, remoteServerPort));
    }
}

