/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.simplejavamail.mailer.internal.socks.common.Socks5Bridge;
import org.simplejavamail.mailer.internal.socks.common.SocksException;
import org.simplejavamail.mailer.internal.socks.socks5server.Socks5Handler;
import org.simplejavamail.mailer.internal.socks.socks5server.SocksSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousSocks5Server
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousSocks5Server.class);
    private final Socks5Bridge socks5Bridge;
    private final int proxyBridgePort;
    private ExecutorService threadPool;
    private ServerSocket serverSocket;
    private boolean stopping = false;
    private boolean running = false;

    public AnonymousSocks5Server(Socks5Bridge socks5Bridge, int proxyBridgePort) {
        this.socks5Bridge = socks5Bridge;
        this.proxyBridgePort = proxyBridgePort;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("server already running!");
        }
        this.running = true;
        try {
            this.threadPool = Executors.newFixedThreadPool(100);
            this.serverSocket = new ServerSocket();
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.bind(new InetSocketAddress(this.proxyBridgePort));
        }
        catch (IOException e) {
            throw new SocksException("error preparing socks5bridge server for authenticated proxy session", e);
        }
        new Thread(this).start();
    }

    public void stop() {
        this.stopping = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new SocksException(e.getMessage(), e);
        }
    }

    @Override
    public void run() {
        LOGGER.info("Starting proxy server at port {}", (Object)this.serverSocket.getLocalPort());
        while (!this.stopping) {
            try {
                LOGGER.info("waiting for new connection...");
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(10000);
                this.threadPool.execute(new Socks5Handler(new SocksSession(socket), this.socks5Bridge));
            }
            catch (IOException e) {
                this.checkIoException(e);
            }
        }
        LOGGER.debug("shutting down...");
        this.threadPool.shutdownNow();
        this.running = false;
        this.stopping = false;
    }

    private void checkIoException(Exception e) {
        if (!e.getMessage().equalsIgnoreCase("socket closed")) {
            this.running = false;
            this.stopping = false;
            throw new SocksException("server crashed...", e);
        }
        LOGGER.debug("socket closed");
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isRunning() {
        return this.running;
    }
}

