/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.config;

import java.util.Properties;
import javax.mail.Session;

public enum TransportStrategy {
    SMTP_PLAIN{

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            return props;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }
    }
    ,
    SMTP_SSL{

        @Override
        public Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.put("mail.transport.protocol", "smtps");
            properties.put("mail.smtps.quitwait", "false");
            return properties;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtps.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtps.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtps.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtps.auth";
        }
    }
    ,
    SMTP_TLS{

        @Override
        public Properties generateProperties() {
            Properties props = super.generateProperties();
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.starttls.enable", "true");
            return props;
        }

        @Override
        public String propertyNameHost() {
            return "mail.smtp.host";
        }

        @Override
        public String propertyNamePort() {
            return "mail.smtp.port";
        }

        @Override
        public String propertyNameUsername() {
            return "mail.smtp.username";
        }

        @Override
        public String propertyNameAuthenticate() {
            return "mail.smtp.auth";
        }
    };

    private static final String TRANSPORT_STRATEGY_MARKER = "simplejavamail.transportstrategy";

    public Properties generateProperties() {
        Properties properties = new Properties();
        properties.put(TRANSPORT_STRATEGY_MARKER, this.name());
        return properties;
    }

    public abstract String propertyNameHost();

    public abstract String propertyNamePort();

    public abstract String propertyNameUsername();

    public abstract String propertyNameAuthenticate();

    public static TransportStrategy findStrategyForSession(Session session) {
        String transportStrategyMarker = session.getProperty(TRANSPORT_STRATEGY_MARKER);
        if (transportStrategyMarker != null) {
            return TransportStrategy.valueOf(transportStrategyMarker);
        }
        return null;
    }

    public String toString(Properties properties) {
        return String.format("session (host: %s, port: %s, username: %s, authenticate: %s, transport: %s)", new Object[]{properties.get(this.propertyNameHost()), properties.get(this.propertyNamePort()), properties.get(this.propertyNameUsername()), properties.get(this.propertyNameAuthenticate()), this});
    }
}

