/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.EqualsHelper;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.util.ConfigLoader;

public class Email {
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients;
    private final List<AttachmentResource> embeddedImages;
    private final List<AttachmentResource> attachments;
    private final Map<String, String> headers;
    private boolean applyDKIMSignature = false;
    private InputStream dkimPrivateKeyInputStream;
    private File dkimPrivateKeyFile;
    private String signingDomain;
    private String selector;

    public Email() {
        this(true);
    }

    public Email(boolean readFromDefaults) {
        this.recipients = new ArrayList<Recipient>();
        this.embeddedImages = new ArrayList<AttachmentResource>();
        this.attachments = new ArrayList<AttachmentResource>();
        this.headers = new HashMap<String, String>();
        if (readFromDefaults) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
                this.setFromAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
                this.setReplyToAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_NAME)) {
                    this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS), Message.RecipientType.TO);
                } else {
                    this.addRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS), Message.RecipientType.TO);
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_NAME)) {
                    this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS), Message.RecipientType.CC);
                } else {
                    this.addRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS), Message.RecipientType.CC);
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                    this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS), Message.RecipientType.BCC);
                } else {
                    this.addRecipients((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS), Message.RecipientType.BCC);
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
                this.setSubject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
            }
        }
    }

    public void signWithDomainKey(@Nonnull File dkimPrivateKeyFile, @Nonnull String signingDomain, @Nonnull String selector) {
        this.applyDKIMSignature = true;
        this.dkimPrivateKeyFile = Preconditions.checkNonEmptyArgument(dkimPrivateKeyFile, "dkimPrivateKeyFile");
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
    }

    public void signWithDomainKey(@Nonnull InputStream dkimPrivateKeyInputStream, @Nonnull String signingDomain, @Nonnull String selector) {
        this.applyDKIMSignature = true;
        this.dkimPrivateKeyInputStream = Preconditions.checkNonEmptyArgument(dkimPrivateKeyInputStream, "dkimPrivateKeyInputStream");
        this.signingDomain = Preconditions.checkNonEmptyArgument(signingDomain, "signingDomain");
        this.selector = Preconditions.checkNonEmptyArgument(selector, "selector");
    }

    public void setFromAddress(@Nullable String name, @Nonnull String fromAddress) {
        this.fromRecipient = new Recipient(name, Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress"), null);
    }

    public void setReplyToAddress(@Nullable String name, @Nonnull String replyToAddress) {
        this.replyToRecipient = new Recipient(name, Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress"), null);
    }

    public void setSubject(@Nonnull String subject) {
        this.subject = Preconditions.checkNonEmptyArgument(subject, "subject");
    }

    public void setText(@Nullable String text) {
        this.text = text;
    }

    public void setTextHTML(@Nullable String textHTML) {
        this.textHTML = textHTML;
    }

    public void addRecipient(@Nullable String name, @Nonnull String address, @Nonnull Message.RecipientType type) {
        Preconditions.checkNonEmptyArgument(address, "address");
        Preconditions.checkNonEmptyArgument(type, "type");
        this.recipients.add(new Recipient(name, address, type));
    }

    public void addRecipients(@Nonnull String emailAddressList, @Nonnull Message.RecipientType type) {
        Preconditions.checkNonEmptyArgument(type, "type");
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        this.addRecipients(type, MiscUtil.extractEmailAddresses(emailAddressList));
    }

    public void addRecipients(@Nonnull Message.RecipientType type, String ... recipientEmailAddressesToAdd) {
        Preconditions.checkNonEmptyArgument(type, "type");
        for (String emailAddress : Preconditions.checkNonEmptyArgument(recipientEmailAddressesToAdd, "recipientEmailAddressesToAdd")) {
            this.recipients.add(new Recipient(null, emailAddress, type));
        }
    }

    public void addRecipients(Recipient ... recipientsToAdd) {
        for (Recipient recipient : Preconditions.checkNonEmptyArgument(recipientsToAdd, "recipientsToAdd")) {
            String address = Preconditions.checkNonEmptyArgument(recipient.getAddress(), "recipient.address");
            Message.RecipientType type = Preconditions.checkNonEmptyArgument(recipient.getType(), "recipient.type");
            this.recipients.add(new Recipient(recipient.getName(), address, type));
        }
    }

    public void addEmbeddedImage(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(@Nullable String name, @Nonnull DataSource imagedata) {
        Preconditions.checkNonEmptyArgument(imagedata, "imagedata");
        if (MiscUtil.valueNullOrEmpty(name) && MiscUtil.valueNullOrEmpty(imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addHeader(@Nonnull String name, @Nonnull Object value) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(value, "value");
        this.headers.put(name, String.valueOf(value));
    }

    public void addAttachment(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(MiscUtil.encodeText(name));
        this.addAttachment(MiscUtil.encodeText(name), (DataSource)dataSource);
    }

    public void addAttachment(@Nullable String name, @Nonnull DataSource filedata) {
        Preconditions.checkNonEmptyArgument(filedata, "filedata");
        this.attachments.add(new AttachmentResource(MiscUtil.encodeText(name), filedata));
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public boolean isApplyDKIMSignature() {
        return this.applyDKIMSignature;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public String getSigningDomain() {
        return this.signingDomain;
    }

    public String getSelector() {
        return this.selector;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        return "Email{\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients + ",\n\tembeddedImages=" + this.embeddedImages + ",\n\tattachments=" + this.attachments + ",\n\theaders=" + this.headers + "\n}";
    }

    Email(@Nonnull EmailBuilder builder) {
        Preconditions.checkNonEmptyArgument(builder, "builder");
        this.recipients = builder.getRecipients();
        this.embeddedImages = builder.getEmbeddedImages();
        this.attachments = builder.getAttachments();
        this.headers = builder.getHeaders();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipient = builder.getReplyToRecipient();
        this.text = builder.getText();
        this.textHTML = builder.getTextHTML();
        this.subject = builder.getSubject();
        if (builder.getDkimPrivateKeyFile() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyFile(), builder.getSigningDomain(), builder.getSelector());
        } else if (builder.getDkimPrivateKeyInputStream() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyInputStream(), builder.getSigningDomain(), builder.getSelector());
        }
    }
}

