/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String DEFAULT_CONFIG_FILENAME = "simplejavamail.properties";
    private static final Map<Property, Object> RESOLVED_PROPERTIES = new HashMap<Property, Object>();

    public static <T> T valueOrProperty(T value, Property property) {
        return ConfigLoader.valueOrProperty(value, property, null);
    }

    public static <T> T valueOrProperty(T value, Property property, T defaultValue) {
        if (!MiscUtil.valueNullOrEmpty(value)) {
            LOGGER.trace("using provided argument value {} for property {}", value, (Object)property);
            return value;
        }
        if (ConfigLoader.hasProperty(property)) {
            T propertyValue = ConfigLoader.getProperty(property);
            LOGGER.trace("using value {} from config file for property {}", propertyValue, (Object)property);
            return propertyValue;
        }
        LOGGER.trace("no value provided as argument or in config file for property {}, using default value {}", (Object)property, defaultValue);
        return defaultValue;
    }

    public static synchronized boolean hasProperty(Property property) {
        return !MiscUtil.valueNullOrEmpty(RESOLVED_PROPERTIES.get((Object)property));
    }

    public static synchronized <T> T getProperty(Property property) {
        return (T)RESOLVED_PROPERTIES.get((Object)property);
    }

    public static Map<Property, Object> loadProperties(String filename, boolean addProperties) {
        InputStream input = ConfigLoader.class.getClassLoader().getResourceAsStream(filename);
        if (input != null) {
            return ConfigLoader.loadProperties(input, addProperties);
        }
        LOGGER.debug("Property file not found on classpath, skipping config file");
        return new HashMap<Property, Object>();
    }

    public static Map<Property, Object> loadProperties(Properties properties, boolean addProperties) {
        if (!addProperties) {
            RESOLVED_PROPERTIES.clear();
        }
        RESOLVED_PROPERTIES.putAll(ConfigLoader.readProperties(properties));
        return Collections.unmodifiableMap(RESOLVED_PROPERTIES);
    }

    public static Map<Property, Object> loadProperties(File filename, boolean addProperties) {
        try {
            return ConfigLoader.loadProperties(new FileInputStream(filename), addProperties);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("error reading properties file from File", e);
        }
    }

    public static synchronized Map<Property, Object> loadProperties(InputStream inputStream, boolean addProperties) {
        Properties prop = new Properties();
        try {
            prop.load(MiscUtil.checkArgumentNotEmpty(inputStream, "InputStream was null"));
        }
        catch (IOException e) {
            throw new IllegalStateException("error reading properties file from inputstream", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!addProperties) {
            RESOLVED_PROPERTIES.clear();
        }
        RESOLVED_PROPERTIES.putAll(ConfigLoader.readProperties(prop));
        return Collections.unmodifiableMap(RESOLVED_PROPERTIES);
    }

    private static Map<Property, Object> readProperties(Properties fileProperties) {
        Properties filePropertiesLeft = new Properties();
        filePropertiesLeft.putAll((Map<?, ?>)fileProperties);
        HashMap<Property, Object> resolvedProps = new HashMap<Property, Object>();
        for (Property prop : Property.values()) {
            Object asSystemProperty;
            if (System.getProperty(prop.key) != null) {
                System.out.println(prop.key + ": " + System.getProperty(prop.key));
            }
            if ((asSystemProperty = ConfigLoader.parsePropertyValue(System.getProperty(prop.key))) != null) {
                resolvedProps.put(prop, asSystemProperty);
                filePropertiesLeft.remove(prop.key);
                continue;
            }
            Object asEnvProperty = ConfigLoader.parsePropertyValue(System.getenv().get(prop.key));
            if (asEnvProperty != null) {
                resolvedProps.put(prop, asEnvProperty);
                filePropertiesLeft.remove(prop.key);
                continue;
            }
            Object rawValue = filePropertiesLeft.remove(prop.key);
            if (rawValue == null) continue;
            if (rawValue instanceof String) {
                resolvedProps.put(prop, ConfigLoader.parsePropertyValue((String)rawValue));
                continue;
            }
            resolvedProps.put(prop, rawValue);
        }
        if (!filePropertiesLeft.isEmpty()) {
            throw new IllegalArgumentException("unknown properties provided " + filePropertiesLeft);
        }
        return resolvedProps;
    }

    static Object parsePropertyValue(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        HashMap<String, Boolean> booleanConversionMap = new HashMap<String, Boolean>();
        booleanConversionMap.put("0", false);
        booleanConversionMap.put("1", true);
        booleanConversionMap.put("false", false);
        booleanConversionMap.put("true", true);
        booleanConversionMap.put("no", false);
        booleanConversionMap.put("yes", true);
        if (booleanConversionMap.containsKey(propertyValue)) {
            return booleanConversionMap.get(propertyValue.toLowerCase());
        }
        try {
            return Integer.valueOf(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return TransportStrategy.valueOf(propertyValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return propertyValue;
            }
        }
    }

    static {
        ConfigLoader.loadProperties(DEFAULT_CONFIG_FILENAME, false);
    }

    public static enum Property {
        JAVAXMAIL_DEBUG("simplejavamail.javaxmail.debug"),
        TRANSPORT_STRATEGY("simplejavamail.transportstrategy"),
        SMTP_HOST("simplejavamail.smtp.host"),
        SMTP_PORT("simplejavamail.smtp.port"),
        SMTP_USERNAME("simplejavamail.smtp.username"),
        SMTP_PASSWORD("simplejavamail.smtp.password"),
        PROXY_HOST("simplejavamail.proxy.host"),
        PROXY_PORT("simplejavamail.proxy.port"),
        PROXY_USERNAME("simplejavamail.proxy.username"),
        PROXY_PASSWORD("simplejavamail.proxy.password"),
        PROXY_SOCKS5BRIDGE_PORT("simplejavamail.proxy.socks5bridge.port"),
        DEFAULT_SUBJECT("simplejavamail.defaults.subject"),
        DEFAULT_FROM_NAME("simplejavamail.defaults.from.name"),
        DEFAULT_FROM_ADDRESS("simplejavamail.defaults.from.address"),
        DEFAULT_REPLYTO_NAME("simplejavamail.defaults.replyto.name"),
        DEFAULT_REPLYTO_ADDRESS("simplejavamail.defaults.replyto.address"),
        DEFAULT_TO_NAME("simplejavamail.defaults.to.name"),
        DEFAULT_TO_ADDRESS("simplejavamail.defaults.to.address"),
        DEFAULT_CC_NAME("simplejavamail.defaults.cc.name"),
        DEFAULT_CC_ADDRESS("simplejavamail.defaults.cc.address"),
        DEFAULT_BCC_NAME("simplejavamail.defaults.bcc.name"),
        DEFAULT_BCC_ADDRESS("simplejavamail.defaults.bcc.address"),
        DEFAULT_POOL_SIZE("simplejavamail.defaults.poolsize"),
        TRANSPORT_MODE_LOGGING_ONLY("simplejavamail.transport.mode.logging.only");

        private final String key;

        private Property(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

