/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport;

import jakarta.mail.Session;
import jakarta.mail.Transport;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.batchsupport.LifecycleDelegatingTransport;
import org.simplejavamail.smtpconnectionpool.SessionTransport;

class LifecycleDelegatingTransportImpl
implements LifecycleDelegatingTransport {
    private final PoolableObject<SessionTransport> pooledTransport;

    LifecycleDelegatingTransportImpl(PoolableObject<SessionTransport> pooledTransport) {
        this.pooledTransport = pooledTransport;
    }

    @NotNull
    public Session getSessionUsedToObtainTransport() {
        return ((SessionTransport)this.pooledTransport.getAllocatedObject()).getSession();
    }

    @NotNull
    public Transport getTransport() {
        return ((SessionTransport)this.pooledTransport.getAllocatedObject()).getTransport();
    }

    public void signalTransportUsed() {
        this.pooledTransport.release();
    }

    public void signalTransportFailed() {
        this.pooledTransport.invalidate();
    }
}

