/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.mail.Session;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.bbottema.clusteredobjectpool.core.ClusterConfig;
import org.bbottema.clusteredobjectpool.core.api.ResourceKey;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.internal.batchsupport.LifecycleDelegatingTransport;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.internal.batchsupport.BatchException;
import org.simplejavamail.internal.batchsupport.ClusterHelper;
import org.simplejavamail.internal.batchsupport.LifecycleDelegatingTransportImpl;
import org.simplejavamail.internal.batchsupport.concurrent.NonJvmBlockingThreadPoolExecutor;
import org.simplejavamail.internal.modules.BatchModule;
import org.simplejavamail.internal.util.concurrent.AsyncOperationHelper;
import org.simplejavamail.smtpconnectionpool.SessionTransport;
import org.simplejavamail.smtpconnectionpool.SmtpConnectionPoolClustered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSupport
implements BatchModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchSupport.class);
    @Nullable
    private SmtpConnectionPoolClustered smtpConnectionPool;

    public CompletableFuture<Void> executeAsync(@NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync((String)processName, (Runnable)operation);
    }

    @NotNull
    public CompletableFuture<Void> executeAsync(@NotNull ExecutorService executorService, @NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync((ExecutorService)executorService, (String)processName, (Runnable)operation);
    }

    @NotNull
    public ExecutorService createDefaultExecutorService(int threadPoolSize, int keepAliveTime) {
        return new NonJvmBlockingThreadPoolExecutor(threadPoolSize, keepAliveTime);
    }

    public void registerToCluster(@NotNull OperationalConfig operationalConfig, @NotNull UUID clusterKey, @NotNull Session session) {
        this.ensureClusterInitialized(operationalConfig);
        ResourceKey.ResourceClusterAndPoolKey poolKey = new ResourceKey.ResourceClusterAndPoolKey((Object)clusterKey, (Object)session);
        if (!Objects.requireNonNull(this.smtpConnectionPool).isPoolRegistered((ResourceKey)poolKey)) {
            this.smtpConnectionPool.registerResourcePool((ResourceKey)poolKey);
        }
    }

    private void ensureClusterInitialized(@NotNull OperationalConfig operationalConfig) {
        if (this.smtpConnectionPool == null) {
            LOGGER.warn("Starting SMTP connection pool cluster: JVM won't shutdown until the pool is manually closed with mailer.shutdownConnectionPool() (for each mailer in the cluster)");
            this.smtpConnectionPool = new SmtpConnectionPoolClustered(ClusterHelper.configureSmtpClusterConfig(operationalConfig));
        } else if (ClusterHelper.compareClusterConfig(operationalConfig, (ClusterConfig<Session, SessionTransport>)this.smtpConnectionPool.getClusterConfig())) {
            LOGGER.warn("Global SMTP Connection pool is already configured with pool defaults from the first Mailer instance, ignoring relevant properties from {}", (Object)operationalConfig);
        }
    }

    @NotNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="This is bullshit, Spotbugs. There's a requireNonNull() right in front of you, you numbnuts")
    public LifecycleDelegatingTransport acquireTransport(@NotNull UUID clusterKey, @NotNull Session session, boolean stickySession) {
        SmtpConnectionPoolClustered smtpConnectionPool = Objects.requireNonNull(this.smtpConnectionPool, "Connection pool used before it was initialized. This shouldn't be possible.");
        this.checkConfigureOAuth2Token(session);
        return Optional.ofNullable(this.getSessionTransportPoolableObject(smtpConnectionPool, clusterKey, session, stickySession)).map(LifecycleDelegatingTransportImpl::new).orElseThrow(() -> new BatchException(String.format("Was unable to obtain a poolable object for key:\t%n%s", session)));
    }

    @Nullable
    private PoolableObject<SessionTransport> getSessionTransportPoolableObject(SmtpConnectionPoolClustered smtpConnectionPool, UUID clusterKey, Session session, boolean stickySession) {
        try {
            return stickySession ? smtpConnectionPool.claimResourceFromPool((ResourceKey)new ResourceKey.ResourceClusterAndPoolKey((Object)clusterKey, (Object)session)) : smtpConnectionPool.claimResourceFromCluster((Object)clusterKey);
        }
        catch (InterruptedException e) {
            throw new BatchException(String.format("Was unable to obtain a poolable object for key:\t%n%s", session), e);
        }
    }

    private void checkConfigureOAuth2Token(Session session) {
        Properties props = session.getProperties();
        if (props.containsKey("simplejavamail.oauth2.token")) {
            props.setProperty("smtp.connection.pool.transport.allocator.oauth2token", props.getProperty("simplejavamail.oauth2.token"));
        }
    }

    @NotNull
    public Future<?> shutdownConnectionPools(@NotNull Session session) {
        if (this.smtpConnectionPool == null) {
            LOGGER.warn("user requested connection pool shutdown, but there is no connection pool to shut down (yet)");
            return CompletableFuture.completedFuture(null);
        }
        return this.smtpConnectionPool.shutdownPool((Object)session);
    }
}

