/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.buffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.simpleframework.util.buffer.Buffer;
import org.simpleframework.util.buffer.BufferException;

class FileBuffer
implements Buffer {
    private OutputStream buffer;
    private Segment segment;
    private File file;
    private int count;
    private boolean closed;

    public FileBuffer(File file) throws IOException {
        this.buffer = new FileOutputStream(file);
        this.file = file;
    }

    public Buffer allocate() throws IOException {
        if (this.closed) {
            throw new BufferException("Buffer has been closed", new Object[0]);
        }
        if (this.segment != null) {
            this.segment.close();
        }
        if (!this.closed) {
            this.segment = new Segment(this, this.count);
        }
        return this.segment;
    }

    public Buffer append(byte[] array) throws IOException {
        return this.append(array, 0, array.length);
    }

    public Buffer append(byte[] array, int off, int size) throws IOException {
        if (this.closed) {
            throw new BufferException("Buffer has been closed", new Object[0]);
        }
        if (size > 0) {
            this.buffer.write(array, off, size);
            this.count += size;
        }
        return this;
    }

    public String encode() throws IOException {
        return this.encode("UTF-8");
    }

    public String encode(String charset) throws IOException {
        InputStream source = this.getInputStream();
        if (this.count <= 0) {
            return new String();
        }
        return this.convert(source, charset, this.count);
    }

    private String convert(InputStream source, String charset, int count) throws IOException {
        byte[] buffer = new byte[count];
        for (int left = count; left > 0; left -= count) {
            int size = source.read(buffer, 0, left);
            if (size != -1) continue;
            throw new BufferException("Could not read buffer", new Object[0]);
        }
        return new String(buffer, charset);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.closed) {
            this.close();
        }
        return this.getInputStream(this.file);
    }

    private InputStream getInputStream(File file) throws IOException {
        FileInputStream source = new FileInputStream(file);
        if (this.count <= 0) {
            ((InputStream)source).close();
        }
        return new Range(source, this.count);
    }

    public void clear() throws IOException {
        if (this.closed) {
            throw new BufferException("Buffer has been closed", new Object[0]);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.buffer.close();
            this.closed = true;
        }
        if (this.segment != null) {
            this.segment.close();
        }
    }

    private class Range
    extends FilterInputStream {
        private int length;
        private boolean closed;

        public Range(InputStream source, int length) {
            super(source);
            this.length = length;
        }

        public int read() throws IOException {
            if (this.length-- > 0) {
                return this.in.read();
            }
            if (this.length <= 0) {
                this.close();
            }
            return -1;
        }

        public int read(byte[] array, int off, int size) throws IOException {
            int left = Math.min(this.length, size);
            if (left > 0) {
                int count = this.in.read(array, off, left);
                if (count > 0) {
                    this.length -= count;
                }
                if (this.length <= 0) {
                    this.close();
                }
                return count;
            }
            return -1;
        }

        public int available() throws IOException {
            return this.length;
        }

        public long skip(long size) throws IOException {
            long left = Math.min((long)this.length, size);
            long skip = this.in.skip(left);
            if (skip > 0L) {
                this.length = (int)((long)this.length - skip);
            }
            if (this.length <= 0) {
                this.close();
            }
            return skip;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.in.close();
                this.closed = true;
            }
        }
    }

    private class Segment
    implements Buffer {
        private Segment segment;
        private Buffer parent;
        private int first;
        private int last;
        private boolean closed;

        public Segment(Buffer parent, int first) {
            this.parent = parent;
            this.first = first;
            this.last = first;
        }

        public Buffer allocate() throws IOException {
            if (this.closed) {
                throw new BufferException("Buffer has been closed", new Object[0]);
            }
            if (this.segment != null) {
                this.segment.close();
            }
            if (!this.closed) {
                this.segment = new Segment(this, this.last);
            }
            return this.segment;
        }

        public Buffer append(byte[] array) throws IOException {
            return this.append(array, 0, array.length);
        }

        public Buffer append(byte[] array, int off, int size) throws IOException {
            if (this.closed) {
                throw new BufferException("Buffer has been closed", new Object[0]);
            }
            if (size > 0) {
                this.parent.append(array, off, size);
                this.last += size;
            }
            return this;
        }

        public String encode() throws IOException {
            return this.encode("UTF-8");
        }

        public String encode(String charset) throws IOException {
            InputStream source = this.getInputStream();
            int count = this.last - this.first;
            if (count <= 0) {
                return new String();
            }
            return FileBuffer.this.convert(source, charset, count);
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream source = new FileInputStream(FileBuffer.this.file);
            int length = this.last - this.first;
            if (this.first > 0) {
                ((InputStream)source).skip(this.first);
            }
            return new Range(source, length);
        }

        public void clear() throws IOException {
            if (this.closed) {
                throw new BufferException("Buffer is closed", new Object[0]);
            }
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
            }
            if (this.segment != null) {
                this.segment.close();
            }
        }
    }
}

