/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.ConnectionException;
import org.simpleframework.transport.connect.SocketAcceptor;
import org.simpleframework.transport.reactor.DirectReactor;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Agent;

class SocketListener
implements Closeable {
    private final SocketAcceptor acceptor;
    private final Reactor reactor;

    public SocketListener(SocketAddress address, Server server, Agent agent) throws IOException {
        this(address, null, server, agent);
    }

    public SocketListener(SocketAddress address, SSLContext context, Server server, Agent agent) throws IOException {
        this.acceptor = new SocketAcceptor(address, context, server, agent);
        this.reactor = new DirectReactor();
        this.process();
    }

    public SocketAddress getAddress() {
        return this.acceptor.getAddress();
    }

    private void process() throws IOException {
        try {
            this.reactor.process(this.acceptor, 16);
        }
        catch (Exception cause) {
            throw new ConnectionException("Listen error", cause);
        }
    }

    public void close() throws IOException {
        try {
            this.acceptor.close();
            this.reactor.stop();
        }
        catch (Exception cause) {
            throw new ConnectionException("Close error", cause);
        }
    }
}

