/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Cursor;
import org.simpleframework.transport.Sender;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportCursor;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportSender;
import org.simpleframework.transport.trace.Trace;

public class TransportChannel
implements Channel {
    private final Transport transport;
    private final SSLEngine engine;
    private final Cursor cursor;
    private final Sender sender;
    private final Trace trace;

    public TransportChannel(Transport transport) {
        this.cursor = new TransportCursor(transport);
        this.sender = new TransportSender(transport);
        this.engine = transport.getEngine();
        this.trace = transport.getTrace();
        this.transport = transport;
    }

    public boolean isSecure() {
        return this.engine != null;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SocketChannel getSocket() {
        return this.transport.getChannel();
    }

    public Map getAttributes() {
        return this.transport.getAttributes();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Sender getSender() {
        return this.sender;
    }

    public void close() {
        try {
            this.transport.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)TransportEvent.ERROR, cause);
        }
    }
}

