/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.lang.reflect.Type;
import org.simpleflatmapper.datastax.DatastaxCrud;
import org.simpleflatmapper.datastax.DatastaxMapperFactory;
import org.simpleflatmapper.datastax.impl.DatastaxCrudFactory;
import org.simpleflatmapper.reflect.meta.AliasProviderService;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.Table;
import org.simpleflatmapper.util.TypeHelper;

public class DatastaxCrudDSL<T, K> {
    private final DatastaxMapperFactory datastaxMapperFactory;
    private final Type targetType;
    private final Type keyType;

    public DatastaxCrudDSL(Type targetType, Type keyType, DatastaxMapperFactory datastaxMapperFactory) {
        this.targetType = targetType;
        this.keyType = keyType;
        this.datastaxMapperFactory = datastaxMapperFactory;
    }

    public DatastaxCrud<T, K> to(Session session) {
        Table table = AliasProviderService.getAliasProvider().getTable(TypeHelper.toClass((Type)this.targetType));
        return this.to(session, this.keyspace(session, table), this.table(session, table, this.targetType));
    }

    private String table(Session session, Table keyspaceTable, Type targetType) {
        String table = keyspaceTable.table();
        if (table == null) {
            String className = TypeHelper.toClass((Type)targetType).getSimpleName();
            for (TableMetadata metadata : session.getCluster().getMetadata().getKeyspace(this.keyspace(session, keyspaceTable)).getTables()) {
                if (DefaultPropertyNameMatcher.of((String)metadata.getName()).matches((CharSequence)className) == null) continue;
                return metadata.getName();
            }
        } else {
            return table;
        }
        throw new IllegalArgumentException("No table define on type " + targetType);
    }

    private String keyspace(Session session, Table table) {
        String keyspace = table.schema();
        if (keyspace == null) {
            keyspace = session.getLoggedKeyspace();
        }
        return keyspace;
    }

    public DatastaxCrud<T, K> to(Session session, String table) {
        Table keyspaceTable = AliasProviderService.getAliasProvider().getTable(TypeHelper.toClass((Type)this.targetType));
        return this.to(session, this.keyspace(session, keyspaceTable), table);
    }

    public DatastaxCrud<T, K> to(Session session, String keyspace, String table) {
        TableMetadata tableMetadata = session.getCluster().getMetadata().getKeyspace(keyspace).getTable(table);
        return DatastaxCrudFactory.newInstance(this.targetType, this.keyType, tableMetadata, session, this.datastaxMapperFactory);
    }
}

