/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvColumnKeyMapperKeyComparator;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.CsvMapperBuilder;
import org.simpleflatmapper.csv.CsvParser;
import org.simpleflatmapper.csv.CsvRow;
import org.simpleflatmapper.csv.CsvRowSet;
import org.simpleflatmapper.csv.impl.CsvColumnDefinitionProviderImpl;
import org.simpleflatmapper.csv.mapper.CsvMappingContextFactoryBuilder;
import org.simpleflatmapper.csv.mapper.CsvRowGetterFactory;
import org.simpleflatmapper.csv.property.CustomReaderFactoryProperty;
import org.simpleflatmapper.csv.property.CustomReaderProperty;
import org.simpleflatmapper.lightningcsv.CsvReader;
import org.simpleflatmapper.lightningcsv.StringReader;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.Result;
import org.simpleflatmapper.map.ResultFieldMapperErrorHandler;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.mapper.AbstractColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.AbstractColumnNameDiscriminatorMapperFactory;
import org.simpleflatmapper.map.mapper.AbstractMapperFactory;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.DynamicSetRowMapper;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.map.mapper.TransformSetRowMapper;
import org.simpleflatmapper.map.property.DefaultDateFormatProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ParameterizedTypeImpl;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;
import org.simpleflatmapper.util.UnaryFactoryWithException;

public final class CsvMapperFactory
extends AbstractColumnNameDiscriminatorMapperFactory<CsvColumnKey, CsvMapperFactory, CsvRow> {
    private static final AbstractColumnNameDiscriminatorMapperFactory.ColumnNameGetterFactory<CsvRow> NAMED_GETTER = new AbstractColumnNameDiscriminatorMapperFactory.ColumnNameGetterFactory<CsvRow>(){

        public <T> Getter<? super CsvRow, ? extends T> getGetter(final String discriminatorColumn, Class<T> discriminatorType) {
            final Converter converter = ConverterService.getInstance().findConverter(String.class, discriminatorType, new Object[0]);
            return new Getter<CsvRow, T>(){

                public T get(CsvRow target) throws Exception {
                    int index = target.getIndex(discriminatorColumn);
                    if (index < 0) {
                        return null;
                    }
                    return converter.convert((Object)target.getString(index));
                }
            };
        }
    };
    private String defaultDateFormat = CsvMapperBuilder.DEFAULT_DATE_FORMAT;

    public static CsvMapperFactory newInstance() {
        return new CsvMapperFactory();
    }

    public static CsvMapperFactory newInstance(AbstractColumnDefinitionProvider<CsvColumnKey> columnDefinitionProvider) {
        return new CsvMapperFactory(columnDefinitionProvider);
    }

    public static CsvMapperFactory newInstance(CsvMapperFactory cfg) {
        return new CsvMapperFactory(cfg);
    }

    private CsvMapperFactory(AbstractColumnDefinitionProvider<CsvColumnKey> columnDefinitionProvider) {
        super(columnDefinitionProvider, (ColumnDefinition)CsvColumnDefinition.identity(), NAMED_GETTER, (ContextualGetterFactory)CsvRowGetterFactory.INSTANCE);
    }

    private CsvMapperFactory() {
        super((AbstractColumnDefinitionProvider)new CsvColumnDefinitionProviderImpl(), (ColumnDefinition)CsvColumnDefinition.identity(), NAMED_GETTER, (ContextualGetterFactory)CsvRowGetterFactory.INSTANCE);
    }

    private CsvMapperFactory(CsvMapperFactory parent) {
        super((AbstractMapperFactory)parent, NAMED_GETTER);
        this.defaultDateFormat = parent.defaultDateFormat;
    }

    public AbstractColumnDefinitionProvider<CsvColumnKey> enrichColumnDefinitions(AbstractColumnDefinitionProvider<CsvColumnKey> columnDefinitions) {
        AbstractColumnDefinitionProvider copy = columnDefinitions.copy();
        copy.addColumnProperty((Predicate)ConstantPredicate.truePredicate(), (Object)new DefaultDateFormatProperty(this.defaultDateFormat));
        return copy;
    }

    public CsvMapperFactory defaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
        return this;
    }

    public CsvMapperFactory addCustomValueReader(String key, CellValueReader<?> cellValueReader) {
        return (CsvMapperFactory)this.addColumnProperty(key, new Object[]{new CustomReaderProperty(cellValueReader)});
    }

    public CsvMapperFactory addCustomValueReader(String key, StringReader<?> stringReader) {
        return (CsvMapperFactory)this.addColumnProperty(key, new Object[]{new CustomReaderProperty(stringReader)});
    }

    public <T> CsvMapper<T> newMapper(Class<T> target) throws MapperBuildingException {
        return this.newMapper((Type)target);
    }

    public <T> CsvMapper<T> newMapper(TypeReference<T> target) throws MapperBuildingException {
        return this.newMapper(target.getType());
    }

    public <T> CsvMapper<T> newMapper(Type target) throws MapperBuildingException {
        ClassMeta classMeta = this.getClassMeta(target);
        return this.newMapper(classMeta);
    }

    public <T> CsvMapper<T> newMapper(ClassMeta<T> classMeta) throws MapperBuildingException {
        return new DynamicCsvSetRowMapper(new SetRowMapperFactory<T>(this, classMeta), new CsvRowMapperKeyFactory(), new CsvRowSetMapperKeyFactory());
    }

    public <T> CsvMapper<Result<T, CsvColumnKey>> newErrorCollectingMapper(Class<T> target) throws MapperBuildingException {
        return this.newErrorCollectingMapper((Type)target);
    }

    public <T> CsvMapper<Result<T, CsvColumnKey>> newErrorCollectingMapper(TypeReference<T> target) throws MapperBuildingException {
        return this.newErrorCollectingMapper(target.getType());
    }

    public <T> CsvMapper<Result<T, CsvColumnKey>> newErrorCollectingMapper(Type target) throws MapperBuildingException {
        ClassMeta classMeta = this.getClassMeta((Type)new ParameterizedTypeImpl(Result.ResultBuilder.class, new Type[]{target, CsvColumnKey.class}));
        CsvMapperFactory csvMapperFactory = (CsvMapperFactory)new CsvMapperFactory(this).fieldMapperErrorHandler((FieldMapperErrorHandler)new ResultFieldMapperErrorHandler());
        final SetRowMapperFactory setRowMapperFactory = new SetRowMapperFactory(csvMapperFactory, classMeta);
        return new DynamicCsvSetRowMapper<Result<T, CsvColumnKey>>(new UnaryFactory<MapperKey<CsvColumnKey>, SetRowMapper<CsvRow, CsvRowSet, Result<T, CsvColumnKey>, IOException>>(){

            public SetRowMapper<CsvRow, CsvRowSet, Result<T, CsvColumnKey>, IOException> newInstance(MapperKey<CsvColumnKey> csvColumnKeyMapperKey) {
                SetRowMapper rowMapper = setRowMapperFactory.newInstance(csvColumnKeyMapperKey);
                return new TransformSetRowMapper(rowMapper, new Function<Result.ResultBuilder<T, CsvColumnKey>, Result<T, CsvColumnKey>>(){

                    public Result<T, CsvColumnKey> apply(Result.ResultBuilder<T, CsvColumnKey> tCsvColumnKeyResultBuilder) {
                        return tCsvColumnKeyResultBuilder.build();
                    }
                });
            }
        }, new CsvRowMapperKeyFactory(), new CsvRowSetMapperKeyFactory());
    }

    public <T> CsvMapperBuilder<T> newBuilder(Class<T> target) {
        return this.newBuilder((Type)target);
    }

    public <T> CsvMapperBuilder<T> newBuilder(TypeReference<T> target) {
        return this.newBuilder(target.getType());
    }

    public <T> CsvMapperBuilder<T> newBuilder(Type target) {
        ClassMeta classMeta = this.getClassMeta(target);
        return this.newBuilder(classMeta);
    }

    public <T> CsvMapperBuilder<T> newBuilder(ClassMeta<T> classMeta) {
        MapperConfig mapperConfig = this.mapperConfig(classMeta.getType());
        CsvMappingContextFactoryBuilder parentBuilder = new CsvMappingContextFactoryBuilder(!mapperConfig.unorderedJoin());
        if (mapperConfig.fieldMapperErrorHandler() instanceof ResultFieldMapperErrorHandler) {
            parentBuilder.addSupplier((Supplier)new Supplier<Object>(){

                public Object get() {
                    return new ArrayList();
                }
            });
        }
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(classMeta, (MapperConfig<CsvColumnKey, CsvRow>)mapperConfig, (ContextualGetterFactory<? super CsvRow, CsvColumnKey>)this.getterFactory, parentBuilder);
        return builder;
    }

    public CsvMapperFactory cellValueReaderFactory(CellValueReaderFactory cellValueReaderFactory) {
        return (CsvMapperFactory)this.addColumnProperty((Predicate)ConstantPredicate.truePredicate(), new Object[]{new CustomReaderFactoryProperty(cellValueReaderFactory)});
    }

    public static class DynamicCsvSetRowMapper<T>
    extends DynamicSetRowMapper<CsvRow, CsvRowSet, T, IOException, CsvColumnKey>
    implements CsvMapper<T> {
        public DynamicCsvSetRowMapper(UnaryFactory<MapperKey<CsvColumnKey>, SetRowMapper<CsvRow, CsvRowSet, T, IOException>> mapperFactory, UnaryFactoryWithException<CsvRow, MapperKey<CsvColumnKey>, IOException> mapperKeyFromRow, UnaryFactoryWithException<CsvRowSet, MapperKey<CsvColumnKey>, IOException> mapperKeyFromSet) {
            super(mapperFactory, mapperKeyFromRow, mapperKeyFromSet, (MapperKeyComparator)CsvColumnKeyMapperKeyComparator.INSTANCE);
        }

        public String toString() {
            return "DynamicCsvSetRowMapper{}";
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle) throws IOException, MappingException {
            this.forEach(this.toCsvRowSet(reader, 0, -1), handle);
            return handle;
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(CsvReader reader, H handle) throws IOException, MappingException {
            this.forEach(this.toCsvRowSet(reader, 0, -1), handle);
            return handle;
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle, int skip) throws IOException, MappingException {
            this.forEach(this.toCsvRowSet(reader, skip, -1), handle);
            return handle;
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle, int skip, int limit) throws IOException, MappingException {
            this.forEach(this.toCsvRowSet(reader, skip, limit), handle);
            return handle;
        }

        @Override
        public <H extends CheckedConsumer<? super T>> H forEach(CsvReader reader, H handle, int limit) throws IOException, MappingException {
            this.forEach(this.toCsvRowSet(reader, 0, limit), handle);
            return handle;
        }

        @Override
        public Iterator<T> iterator(Reader reader) throws IOException {
            return this.iterator(this.toCsvRowSet(reader, 0, -1));
        }

        @Override
        public Iterator<T> iterator(CsvReader reader) throws IOException {
            return this.iterator(this.toCsvRowSet(reader, 0, -1));
        }

        @Override
        public Iterator<T> iterator(Reader reader, int skip) throws IOException {
            return this.iterator(this.toCsvRowSet(reader, skip, -1));
        }

        @Override
        public Stream<T> stream(Reader reader) throws IOException {
            return this.stream(this.toCsvRowSet(reader, 0, -1));
        }

        @Override
        public Stream<T> stream(CsvReader reader) throws IOException {
            return this.stream(this.toCsvRowSet(reader, 0, -1));
        }

        @Override
        public Stream<T> stream(Reader reader, int skip) throws IOException {
            return this.stream(this.toCsvRowSet(reader, skip, -1));
        }

        private CsvRowSet toCsvRowSet(Reader reader, int skip, int limit) throws IOException {
            return this.toCsvRowSet(CsvParser.reader(reader), skip, limit);
        }

        private CsvRowSet toCsvRowSet(CsvReader reader, int skip, int limit) throws IOException {
            reader.skipRows(skip);
            return new CsvRowSet(reader, limit);
        }
    }

    private static class SetRowMapperFactory<T>
    implements UnaryFactory<MapperKey<CsvColumnKey>, SetRowMapper<CsvRow, CsvRowSet, T, IOException>> {
        private final CsvMapperFactory csvMapperFactory;
        private final ClassMeta<T> classMeta;

        public SetRowMapperFactory(CsvMapperFactory csvMapperFactory, ClassMeta<T> classMeta) {
            this.csvMapperFactory = csvMapperFactory;
            this.classMeta = classMeta;
        }

        public SetRowMapper<CsvRow, CsvRowSet, T, IOException> newInstance(MapperKey<CsvColumnKey> mapperKey) {
            CsvMapperBuilder<T> builder = this.csvMapperFactory.newBuilder(this.classMeta);
            for (CsvColumnKey key : (CsvColumnKey[])mapperKey.getColumns()) {
                builder.addMapping(key, new Object[0]);
            }
            return builder.mapper();
        }
    }

    private static class CsvRowMapperKeyFactory
    implements UnaryFactoryWithException<CsvRow, MapperKey<CsvColumnKey>, IOException> {
        private CsvRowMapperKeyFactory() {
        }

        public MapperKey<CsvColumnKey> newInstance(CsvRow csvRow) throws IOException {
            return new MapperKey((FieldKey[])csvRow.getKeys());
        }
    }

    private static class CsvRowSetMapperKeyFactory
    implements UnaryFactoryWithException<CsvRowSet, MapperKey<CsvColumnKey>, IOException> {
        private CsvRowSetMapperKeyFactory() {
        }

        public MapperKey<CsvColumnKey> newInstance(CsvRowSet csvRowSet) throws IOException {
            return new MapperKey((FieldKey[])csvRowSet.getKeys());
        }
    }
}

