/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvColumnKeyMapperKeyComparator;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.CsvMapperBuilder;
import org.simpleflatmapper.csv.CsvParser;
import org.simpleflatmapper.csv.impl.CellValueReaderFactoryImpl;
import org.simpleflatmapper.csv.impl.ColumnsMapperKeyBuilderCellConsumer;
import org.simpleflatmapper.csv.impl.CsvMapperImpl;
import org.simpleflatmapper.csv.impl.CsvMapperIterator;
import org.simpleflatmapper.csv.mapper.CsvMapperCellConsumer;
import org.simpleflatmapper.lightningcsv.CsvReader;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.CheckedConsumer;

public final class DynamicCsvMapper<T>
implements CsvMapper<T> {
    private final ClassMeta<T> classMeta;
    private final Type target;
    private final String defaultDateFormat;
    private final CellValueReaderFactory cellValueReaderFactory;
    private final MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig;
    private final MapperCache<CsvColumnKey, CsvMapperImpl<T>> mapperCache = new MapperCache((MapperKeyComparator)CsvColumnKeyMapperKeyComparator.INSTANCE);

    public DynamicCsvMapper(Type target, ClassMeta<T> classMeta, String defaultDateFormat, CellValueReaderFactory cellValueReaderFactory, MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig) {
        this.classMeta = (ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta);
        this.target = (Type)Asserts.requireNonNull((String)"target", (Object)target);
        this.defaultDateFormat = defaultDateFormat;
        this.mapperConfig = mapperConfig;
        this.cellValueReaderFactory = cellValueReaderFactory;
    }

    public DynamicCsvMapper(Type target, ClassMeta<T> classMeta, ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey> columnDefinitionProvider) {
        this(target, classMeta, "yyyy-MM-dd HH:mm:ss", new CellValueReaderFactoryImpl(), (MapperConfig<CsvColumnKey, CsvColumnDefinition>)MapperConfig.config(columnDefinitionProvider));
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle) throws IOException, MappingException {
        return this.forEach(CsvParser.reader(reader), handle);
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(CsvReader csvReader, H handle) throws IOException {
        CsvMapperCellConsumer mapperCellConsumer = this.getDelegateMapper(csvReader).newCellConsumer(handle);
        csvReader.parseAll((CellConsumer)mapperCellConsumer);
        return handle;
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle, int skip) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handle);
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(CsvReader csvReader, H handle, int limit) throws IOException {
        CsvMapperCellConsumer mapperCellConsumer = this.getDelegateMapper(csvReader).newCellConsumer(handle);
        csvReader.parseRows((CellConsumer)mapperCellConsumer, limit);
        return handle;
    }

    @Override
    public <H extends CheckedConsumer<? super T>> H forEach(Reader reader, H handle, int skip, int limit) throws IOException, MappingException {
        return this.forEach(CsvParser.skip(skip).reader(reader), handle, limit);
    }

    @Override
    public Iterator<T> iterator(Reader reader) throws IOException {
        CsvReader csvReader = CsvParser.reader(reader);
        return this.iterator(csvReader);
    }

    @Override
    public Iterator<T> iterator(CsvReader csvReader) throws IOException {
        CsvMapperImpl<T> mapper = this.getDelegateMapper(csvReader);
        return new CsvMapperIterator<T>(csvReader, mapper);
    }

    @Override
    public Iterator<T> iterator(Reader reader, int skip) throws IOException {
        return this.iterator(CsvParser.skip(skip).reader(reader));
    }

    private CsvMapperImpl<T> getDelegateMapper(CsvReader reader) throws IOException {
        ColumnsMapperKeyBuilderCellConsumer keyBuilderCellConsumer = new ColumnsMapperKeyBuilderCellConsumer();
        reader.parseRow((CellConsumer)keyBuilderCellConsumer);
        return this.getCsvMapper(keyBuilderCellConsumer.getKey());
    }

    @Override
    public Stream<T> stream(Reader reader) throws IOException {
        CsvReader csvReader = CsvParser.reader(reader);
        return this.stream(csvReader);
    }

    @Override
    public Stream<T> stream(CsvReader csvReader) throws IOException {
        CsvMapperImpl<T> mapper;
        CsvMapperImpl<T> csvMapperImpl = mapper = this.getDelegateMapper(csvReader);
        csvMapperImpl.getClass();
        return StreamSupport.stream(csvMapperImpl.new CsvMapperImpl.CsvSpliterator(csvReader), false);
    }

    @Override
    public Stream<T> stream(Reader reader, int skip) throws IOException {
        return this.stream(CsvParser.skip(skip).reader(reader));
    }

    protected CsvMapperImpl<T> getCsvMapper(MapperKey<CsvColumnKey> key) {
        CsvMapperImpl<T> csvMapperImpl = (CsvMapperImpl<T>)this.mapperCache.get(key);
        if (csvMapperImpl == null) {
            csvMapperImpl = this.buildMapper(key);
            this.mapperCache.add(key, csvMapperImpl);
        }
        return csvMapperImpl;
    }

    private CsvMapperImpl<T> buildMapper(MapperKey<CsvColumnKey> key) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(this.target, this.classMeta, 0, this.cellValueReaderFactory, this.mapperConfig);
        builder.setDefaultDateFormat(this.defaultDateFormat);
        for (CsvColumnKey col : (CsvColumnKey[])key.getColumns()) {
            builder.addMapping(col, CsvColumnDefinition.identity());
        }
        return (CsvMapperImpl)builder.mapper();
    }

    public String toString() {
        return "DynamicCsvMapper{target=" + this.target + ", mapperCache=" + this.mapperCache + '}';
    }
}

