/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CharBuffer;

public final class ReaderCharBuffer
extends CharBuffer {
    private final int maxBufferSize;
    private final Reader reader;
    private int resizeThreshold;

    public ReaderCharBuffer(int bufferSize, int maxBufferLength, Reader reader) {
        super(new char[bufferSize], 0);
        this.maxBufferSize = maxBufferLength;
        this.reader = reader;
        this.resizeThreshold = (this.buffer.length >> 2) * 3;
    }

    @Override
    public final boolean next() throws IOException {
        int effectiveMark = Math.min(this.bufferSize, this.mark);
        int newSize = this.bufferSize - effectiveMark;
        System.arraycopy(this.buffer, effectiveMark, this.buffer, 0, newSize);
        this.bufferSize = newSize;
        this.mark = 0;
        if (this.bufferSize > this.resizeThreshold) {
            int newBufferSize = Math.min(this.maxBufferSize, this.buffer.length << 1);
            if (newBufferSize <= this.bufferSize) {
                throw new BufferOverflowException("The content in the csv cell exceed the maxSizeBuffer " + this.maxBufferSize + ", see CsvParser.DSL.maxSizeBuffer(int) to change the default value");
            }
            this.buffer = Arrays.copyOf(this.buffer, newBufferSize);
            this.resizeThreshold = (newBufferSize >> 2) * 3;
        }
        int l = this.reader.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize);
        this.bufferSize += Math.max(0, l);
        return l > 0;
    }
}

