/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.util.Asserts;

public final class YamlCommentUnescapeContentCellConsumer
implements CellConsumer {
    private static final int COMMENT = 2;
    private static final int REGULAR_ROW = 1;
    private static final int NONE = 0;
    private final CellConsumer rowDelegate;
    private final CellConsumer commentDelegate;
    private final CellPreProcessor rowCellPreProcessor;
    private int state;

    public YamlCommentUnescapeContentCellConsumer(CellPreProcessor rowCellPreProcessor, CellConsumer rowDelegate, CellConsumer commentDelegate) {
        this.rowCellPreProcessor = rowCellPreProcessor;
        this.rowDelegate = (CellConsumer)Asserts.requireNonNull((String)"rowDelegate", (Object)rowDelegate);
        this.commentDelegate = (CellConsumer)Asserts.requireNonNull((String)"commentDelegate", (Object)commentDelegate);
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.state == 0) {
            int n = this.state = length > 0 && chars[offset] == '#' ? 2 : 1;
        }
        if (this.state != 2) {
            this.rowCellPreProcessor.newCell(chars, offset, offset + length, this.rowDelegate);
        } else {
            this.commentDelegate.newCell(chars, offset, length);
        }
    }

    @Override
    public boolean endOfRow() {
        boolean b = this.state != 2 ? this.rowDelegate.endOfRow() : this.commentDelegate.endOfRow();
        this.state = 0;
        return b;
    }

    @Override
    public void end() {
        this.rowDelegate.end();
        this.commentDelegate.end();
    }
}

