/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.CharCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.CharacterSetter;

public class CharDelayedCellSetter<T>
implements DelayedCellSetter<T, Character> {
    private final CharacterSetter<? super T> setter;
    private final CharCellValueReader reader;
    private char value;
    private boolean isNull;

    public CharDelayedCellSetter(CharacterSetter<? super T> setter, CharCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Character consumeValue() {
        return this.isNull ? null : Character.valueOf(this.consumeCharacter());
    }

    @Override
    public Character peekValue() {
        return this.isNull ? null : Character.valueOf(this.value);
    }

    public char consumeCharacter() {
        char v = this.value;
        this.value = '\u0000';
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setCharacter(t, this.consumeCharacter());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readChar(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "CharDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

