/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.asm;

import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.ParsingContextFactory;
import org.simpleflatmapper.csv.impl.asm.CsvMapperCellHandlerBuilder;
import org.simpleflatmapper.csv.impl.asm.CsvMapperKey;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandlerFactory;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.error.RethrowFieldMapperErrorHandler;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.util.TypeHelper;

public class CsvAsmFactory {
    private final AsmFactory asmFactory;
    private final ConcurrentMap<CsvMapperKey, Class<? extends CsvMapperCellHandlerFactory<?>>> csvMapperCache = new ConcurrentHashMap();

    public CsvAsmFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    public <T> CsvMapperCellHandlerFactory<T> createCsvMapperCellHandler(Type target, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters, Instantiator<CsvMapperCellHandler<T>, T> instantiator, CsvColumnKey[] keys, ParsingContextFactory parsingContextFactory, FieldMapperErrorHandler<? super CsvColumnKey> fieldErrorHandler, int maxMethodSize) throws Exception {
        CsvMapperKey key = new CsvMapperKey(keys, setters, delayedCellSetterFactories, instantiator, target, fieldErrorHandler, maxMethodSize);
        Class typeFactory = (Class)this.csvMapperCache.get(key);
        if (typeFactory == null) {
            String className = this.generateClassNameCsvMapperCellHandler(target, delayedCellSetterFactories, setters);
            String factoryName = className + "Factory";
            byte[] bytes = CsvMapperCellHandlerBuilder.createTargetSetterClass(className, delayedCellSetterFactories, setters, target, fieldErrorHandler == null || fieldErrorHandler instanceof RethrowFieldMapperErrorHandler, maxMethodSize);
            byte[] bytesFactory = CsvMapperCellHandlerBuilder.createTargetSetterFactory(factoryName, className, target);
            this.asmFactory.createClass(className, bytes, target.getClass().getClassLoader());
            typeFactory = this.asmFactory.createClass(factoryName, bytesFactory, target.getClass().getClassLoader());
            this.csvMapperCache.put(key, typeFactory);
        }
        return (CsvMapperCellHandlerFactory)typeFactory.getConstructor(Instantiator.class, CsvColumnKey[].class, ParsingContextFactory.class, FieldMapperErrorHandler.class).newInstance(new Object[]{instantiator, keys, parsingContextFactory, fieldErrorHandler});
    }

    private <T> String generateClassNameCsvMapperCellHandler(Type target, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.simpleflatmapper.csv.generated.").append(this.asmFactory.getPackageName(target)).append(".AsmCsvMapperCellHandlerTo").append(this.asmFactory.replaceArray(TypeHelper.toClass((Type)target).getSimpleName()));
        if (delayedCellSetterFactories.length > 0) {
            sb.append("DS").append(Integer.toString(delayedCellSetterFactories.length));
        }
        if (setters.length > 0) {
            sb.append("S").append(Integer.toString(setters.length));
        }
        sb.append("_I").append(Long.toHexString(this.asmFactory.getNextClassNumber()));
        return sb.toString();
    }
}

