/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.ConfigurableCharConsumer;
import org.simpleflatmapper.csv.parser.TextFormat;
import org.simpleflatmapper.ow2asm.ClassReader;
import org.simpleflatmapper.ow2asm.ClassVisitor;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.FactoryClassLoader;
import org.simpleflatmapper.reflect.asm.AsmUtils;

public abstract class AbstractCharConsumer {
    private static final FactoryClassLoader classLoader = new FactoryClassLoader(AbstractCharConsumer.class.getClassLoader());
    private static final Object lock = new Object();
    private static final SpecialisationKey RFC4180 = new SpecialisationKey(false, new TextFormat(',', '\"', '\"', false));
    private static final Constructor<? extends AbstractCharConsumer> RFC4180_CC;
    private static final ConcurrentHashMap<SpecialisationKey, Constructor<? extends AbstractCharConsumer>> specialisedCharConsumers;

    public abstract void consumeAllBuffer(CellConsumer var1);

    public abstract boolean consumeToNextRow(CellConsumer var1);

    public abstract void finish(CellConsumer var1);

    public abstract boolean next() throws IOException;

    public static AbstractCharConsumer newCharConsumer(TextFormat textFormat, CharBuffer charBuffer, CellPreProcessor cellTransformer, boolean specialisedCharConsumer) {
        if (specialisedCharConsumer) {
            Constructor<? extends AbstractCharConsumer> constructor;
            SpecialisationKey key = new SpecialisationKey(cellTransformer.ignoreLeadingSpace(), textFormat);
            if (key.equals(RFC4180)) {
                constructor = RFC4180_CC;
            } else {
                constructor = specialisedCharConsumers.get(key);
                if (constructor == null && specialisedCharConsumers.size() < 64) {
                    constructor = AbstractCharConsumer.createNewSpecialisedCharConsumer(key);
                }
            }
            if (constructor != null) {
                try {
                    return constructor.newInstance(charBuffer, key.textFormat, cellTransformer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return new ConfigurableCharConsumer(charBuffer, textFormat, cellTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<? extends AbstractCharConsumer> createNewSpecialisedCharConsumer(SpecialisationKey key) {
        Object object = lock;
        synchronized (object) {
            Constructor<? extends AbstractCharConsumer> constructor = specialisedCharConsumers.get(key);
            if (constructor == null && specialisedCharConsumers.size() < 64 && (constructor = AbstractCharConsumer.generateSpecialisedCharConsumer(key)) != null) {
                specialisedCharConsumers.put(key, constructor);
            }
            return constructor;
        }
    }

    private static Constructor<? extends AbstractCharConsumer> generateSpecialisedCharConsumer(final SpecialisationKey key) {
        try {
            final String newName = "org/simpleflatmapper/csv/parser/Asm_" + (key.ignoreLeadingSpace ? "Ils_" : "") + (key.textFormat.yamlComment ? "Yaml_" : "") + "S_" + Integer.toHexString(key.textFormat.separatorChar) + "_Q_" + Integer.toHexString(key.textFormat.quoteChar) + "_E_" + Integer.toHexString(key.textFormat.escapeChar) + "_CharConsumer";
            final HashSet<String> oldNames = new HashSet<String>(Arrays.asList("org/simpleflatmapper/csv/parser/ConfigurableCharConsumer"));
            ClassReader reader = new ClassReader(ConfigurableCharConsumer.class.getResourceAsStream("ConfigurableCharConsumer.class"));
            ClassWriter writer = new ClassWriter(reader, 3);
            ClassVisitor visitor = new ClassVisitor(327680, (ClassVisitor)writer){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, newName, signature, superName, interfaces);
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                    if (name.equals("ignoreLeadingSpace")) {
                        mv.visitCode();
                        mv.visitInsn(key.ignoreLeadingSpace ? 4 : 3);
                        mv.visitInsn(172);
                        mv.visitMaxs(1, 1);
                        mv.visitEnd();
                        return null;
                    }
                    if (name.equals("yamlComment")) {
                        mv.visitCode();
                        mv.visitInsn(key.textFormat.yamlComment ? 4 : 3);
                        mv.visitInsn(172);
                        mv.visitMaxs(1, 1);
                        mv.visitEnd();
                        return null;
                    }
                    if (name.equals("escapeChar")) {
                        mv.visitCode();
                        mv.visitIntInsn(16, (int)key.textFormat.escapeChar);
                        mv.visitInsn(172);
                        mv.visitMaxs(1, 1);
                        mv.visitEnd();
                        return null;
                    }
                    if (name.equals("separatorChar")) {
                        mv.visitCode();
                        mv.visitIntInsn(16, (int)key.textFormat.separatorChar);
                        mv.visitInsn(172);
                        mv.visitMaxs(1, 1);
                        mv.visitEnd();
                        return null;
                    }
                    if (name.equals("quoteChar")) {
                        mv.visitCode();
                        mv.visitIntInsn(16, (int)key.textFormat.quoteChar);
                        mv.visitInsn(172);
                        mv.visitMaxs(1, 1);
                        mv.visitEnd();
                        return null;
                    }
                    return new MethodVisitor(327680, mv){

                        public void visitTypeInsn(int i, String s) {
                            if (oldNames.contains(s)) {
                                s = newName;
                            }
                            this.mv.visitTypeInsn(i, s);
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            if (oldNames.contains(owner)) {
                                this.mv.visitFieldInsn(opcode, newName, name, this.fix(desc));
                            } else {
                                this.mv.visitFieldInsn(opcode, owner, name, this.fix(desc));
                            }
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (oldNames.contains(owner)) {
                                this.mv.visitMethodInsn(opcode, newName, name, this.fix(desc), itf);
                            } else {
                                this.mv.visitMethodInsn(opcode, owner, name, this.fix(desc), itf);
                            }
                        }

                        private String fix(String s) {
                            if (s != null) {
                                for (String name : oldNames) {
                                    if (s.indexOf(name) == -1) continue;
                                    s = s.replaceAll(name, newName);
                                }
                            }
                            return s;
                        }
                    };
                }
            };
            reader.accept(visitor, 0);
            byte[] bytes = writer.toByteArray();
            String className = newName.replace('/', '.');
            AsmUtils.writeClassToFile((String)className, (byte[])bytes);
            Class clazz = classLoader.registerClass(className, bytes, null);
            return clazz.getConstructor(CharBuffer.class, TextFormat.class, CellPreProcessor.class);
        }
        catch (Exception e) {
            System.err.println("Error creating specialised parser " + e.getMessage());
            return null;
        }
    }

    static {
        try {
            RFC4180_CC = AbstractCharConsumer.generateSpecialisedCharConsumer(RFC4180);
        }
        catch (Exception e) {
            throw new Error("Unexpected error " + e.getMessage(), e);
        }
        specialisedCharConsumers = new ConcurrentHashMap();
    }

    private static class SpecialisationKey {
        final boolean ignoreLeadingSpace;
        final TextFormat textFormat;

        private SpecialisationKey(boolean ignoreLeadingSpace, TextFormat textFormat) {
            this.ignoreLeadingSpace = ignoreLeadingSpace;
            this.textFormat = textFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecialisationKey key = (SpecialisationKey)o;
            if (this.ignoreLeadingSpace != key.ignoreLeadingSpace) {
                return false;
            }
            return this.textFormat.equals(key.textFormat);
        }

        public int hashCode() {
            int result = this.ignoreLeadingSpace ? 1 : 0;
            result = 31 * result + this.textFormat.hashCode();
            return result;
        }
    }
}

