/*
 * Decompiled with CFR 0.152.
 */
package org.signal.grpc.simple;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.ServerCallStreamObserver;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;

class ServerResponseSubscriber<T>
implements Flow.Subscriber<T> {
    private final ServerCallStreamObserver<T> responseObserver;
    private final Function<Throwable, Optional<Status>> exceptionMapper;
    private Flow.Subscription subscription;

    public ServerResponseSubscriber(ServerCallStreamObserver<T> responseObserver, Function<Throwable, Optional<Status>> exceptionMapper) {
        this.responseObserver = responseObserver;
        this.exceptionMapper = exceptionMapper;
        responseObserver.setOnCancelHandler(this::onResponseObserverCancelled);
        responseObserver.setOnCloseHandler(this::onResponseObserverCancelled);
        responseObserver.setOnReadyHandler(this::onResponseObserverReady);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        if (this.responseObserver.isReady()) {
            subscription.request(1L);
        }
    }

    @Override
    public void onNext(T item) {
        if (!this.responseObserver.isCancelled()) {
            this.responseObserver.onNext(item);
            if (this.responseObserver.isReady()) {
                this.subscription.request(1L);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        StatusException statusException = this.exceptionMapper.apply(throwable).orElseGet(() -> Status.fromThrowable((Throwable)throwable)).asException();
        if (!this.responseObserver.isCancelled()) {
            this.responseObserver.onError((Throwable)statusException);
        }
    }

    @Override
    public void onComplete() {
        if (!this.responseObserver.isCancelled()) {
            this.responseObserver.onCompleted();
        }
    }

    private void onResponseObserverReady() {
        if (this.responseObserver.isReady()) {
            this.subscription.request(1L);
        }
    }

    private void onResponseObserverCancelled() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }
}

