/*
 * Decompiled with CFR 0.152.
 */
package org.signal.grpc.simple;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.signal.grpc.simple.CheckedFunction;
import org.signal.grpc.simple.ClientRequestPublisher;
import org.signal.grpc.simple.ServerResponseSubscriber;

public class ServerCalls {
    private ServerCalls() {
    }

    public static <Req, Resp> void unaryCall(Req request, ServerCallStreamObserver<Resp> responseObserver, CheckedFunction<Req, Resp> delegate, Function<Throwable, Optional<Status>> exceptionMapper) {
        try {
            Resp response = delegate.apply(request);
            if (!responseObserver.isCancelled()) {
                responseObserver.onNext(response);
                responseObserver.onCompleted();
            }
        }
        catch (Exception e) {
            ServerCalls.handleDelegateException(e, exceptionMapper, responseObserver);
        }
    }

    public static <Req, Resp> void serverStreamingCall(Req request, ServerCallStreamObserver<Resp> responseObserver, CheckedFunction<Req, Flow.Publisher<Resp>> delegate, Function<Throwable, Optional<Status>> exceptionMapper) {
        try {
            delegate.apply(request).subscribe(new ServerResponseSubscriber<Resp>(responseObserver, exceptionMapper));
        }
        catch (Exception e) {
            ServerCalls.handleDelegateException(e, exceptionMapper, responseObserver);
        }
    }

    public static <Req, Resp> StreamObserver<Req> clientStreamingCall(ServerCallStreamObserver<Resp> responseObserver, CheckedFunction<Flow.Publisher<Req>, CompletionStage<Resp>> delegate, Function<Throwable, Optional<Status>> exceptionMapper) {
        ClientRequestPublisher clientRequestPublisher = new ClientRequestPublisher(responseObserver);
        try {
            delegate.apply(clientRequestPublisher).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    ServerCalls.handleDelegateException(throwable, exceptionMapper, responseObserver);
                } else if (!responseObserver.isCancelled()) {
                    responseObserver.onNext(response);
                    responseObserver.onCompleted();
                }
            });
        }
        catch (Exception e) {
            ServerCalls.handleDelegateException(e, exceptionMapper, responseObserver);
        }
        return clientRequestPublisher;
    }

    public static <Req, Resp> StreamObserver<Req> bidirectionalStreamingCall(ServerCallStreamObserver<Resp> responseObserver, CheckedFunction<Flow.Publisher<Req>, Flow.Publisher<Resp>> delegate, Function<Throwable, Optional<Status>> exceptionMapper) {
        ClientRequestPublisher clientRequestPublisher = new ClientRequestPublisher(responseObserver);
        try {
            delegate.apply(clientRequestPublisher).subscribe(new ServerResponseSubscriber<Resp>(responseObserver, exceptionMapper));
        }
        catch (Exception e) {
            ServerCalls.handleDelegateException(e, exceptionMapper, responseObserver);
        }
        return clientRequestPublisher;
    }

    private static void handleDelegateException(Throwable throwable, Function<Throwable, Optional<Status>> exceptionMapper, ServerCallStreamObserver<?> responseObserver) {
        StatusException statusException = exceptionMapper.apply(throwable).orElseGet(() -> Status.fromThrowable((Throwable)throwable)).asException();
        if (!responseObserver.isCancelled()) {
            responseObserver.onError((Throwable)statusException);
        }
    }
}

