/*
 * Decompiled with CFR 0.152.
 */
package org.signal.grpc.simple;

import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.Flow;

class ClientRequestPublisher<T>
implements StreamObserver<T>,
Flow.Publisher<T> {
    private final ServerCallStreamObserver<?> responseObserver;
    private Flow.Subscriber<? super T> subscriber;

    public ClientRequestPublisher(ServerCallStreamObserver<?> responseObserver) {
        this.responseObserver = responseObserver;
        this.responseObserver.disableAutoRequest();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (this.subscriber != null) {
            subscriber.onError(new IllegalStateException("Client request publishers only allow a single subscriber"));
            return;
        }
        this.subscriber = subscriber;
        subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                ClientRequestPublisher.this.responseObserver.request((int)Math.min(n, Integer.MAX_VALUE));
            }

            @Override
            public void cancel() {
            }
        });
    }

    public void onNext(T value) {
        if (this.subscriber == null) {
            throw new IllegalStateException("No subscriber present");
        }
        this.subscriber.onNext(value);
    }

    public void onError(Throwable t) {
        if (this.subscriber == null) {
            throw new IllegalStateException("No subscriber present");
        }
        this.subscriber.onError(t);
    }

    public void onCompleted() {
        if (this.subscriber == null) {
            throw new IllegalStateException("No subscriber present");
        }
        this.subscriber.onComplete();
    }
}

