/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import com.google.protobuf.InvalidProtocolBufferException;
import org.signal.libsignal.metadata.SignalProtos;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.util.guava.Optional;

public class SenderCertificate {
    private final ServerCertificate signer;
    private final ECPublicKey key;
    private final int senderDeviceId;
    private final Optional<String> senderUuid;
    private final Optional<String> senderE164;
    private final long expiration;
    private final byte[] serialized;
    private final byte[] certificate;
    private final byte[] signature;

    public SenderCertificate(byte[] serialized) throws InvalidCertificateException {
        try {
            SignalProtos.SenderCertificate wrapper = SignalProtos.SenderCertificate.parseFrom(serialized);
            if (!wrapper.hasSignature() || !wrapper.hasCertificate()) {
                throw new InvalidCertificateException("Missing fields");
            }
            SignalProtos.SenderCertificate.Certificate certificate = SignalProtos.SenderCertificate.Certificate.parseFrom(wrapper.getCertificate());
            if (!(certificate.hasSigner() && certificate.hasIdentityKey() && certificate.hasSenderDevice() && certificate.hasExpires() && (certificate.hasSenderUuid() || certificate.hasSenderE164()))) {
                throw new InvalidCertificateException("Missing fields");
            }
            this.signer = new ServerCertificate(certificate.getSigner().toByteArray());
            this.key = Curve.decodePoint((byte[])certificate.getIdentityKey().toByteArray(), (int)0);
            this.senderUuid = certificate.hasSenderUuid() ? Optional.of((Object)certificate.getSenderUuid()) : Optional.absent();
            this.senderE164 = certificate.hasSenderE164() ? Optional.of((Object)certificate.getSenderE164()) : Optional.absent();
            this.senderDeviceId = certificate.getSenderDevice();
            this.expiration = certificate.getExpires();
            this.serialized = serialized;
            this.certificate = wrapper.getCertificate().toByteArray();
            this.signature = wrapper.getSignature().toByteArray();
        }
        catch (InvalidProtocolBufferException | InvalidKeyException e) {
            throw new InvalidCertificateException((Exception)e);
        }
    }

    public ServerCertificate getSigner() {
        return this.signer;
    }

    public ECPublicKey getKey() {
        return this.key;
    }

    public int getSenderDeviceId() {
        return this.senderDeviceId;
    }

    public Optional<String> getSenderUuid() {
        return this.senderUuid;
    }

    public Optional<String> getSenderE164() {
        return this.senderE164;
    }

    public String getSender() {
        return (String)this.senderE164.or(this.senderUuid).orNull();
    }

    public long getExpiration() {
        return this.expiration;
    }

    public byte[] getSerialized() {
        return this.serialized;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

