/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.HashSet;
import java.util.Set;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.certificate.ServerCertificate;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;

public class CertificateValidator {
    private static final Set<Integer> REVOKED = new HashSet<Integer>(){};
    private final ECPublicKey trustRoot;

    public CertificateValidator(ECPublicKey trustRoot) {
        this.trustRoot = trustRoot;
    }

    public void validate(SenderCertificate certificate, long validationTime) throws InvalidCertificateException {
        try {
            ServerCertificate serverCertificate = certificate.getSigner();
            this.validate(serverCertificate);
            if (!Curve.verifySignature((ECPublicKey)serverCertificate.getKey(), (byte[])certificate.getCertificate(), (byte[])certificate.getSignature())) {
                throw new InvalidCertificateException("Signature failed");
            }
            if (validationTime > certificate.getExpiration()) {
                throw new InvalidCertificateException("Certificate is expired");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidCertificateException((Exception)((Object)e));
        }
    }

    void validate(ServerCertificate certificate) throws InvalidCertificateException {
        try {
            if (!Curve.verifySignature((ECPublicKey)this.trustRoot, (byte[])certificate.getCertificate(), (byte[])certificate.getSignature())) {
                throw new InvalidCertificateException("Signature failed");
            }
            if (REVOKED.contains(certificate.getKeyId())) {
                throw new InvalidCertificateException("Server certificate has been revoked");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidCertificateException((Exception)((Object)e));
        }
    }
}

