/*
 * Decompiled with CFR 0.152.
 */
package org.signal.ringrtc;

public class Log {
    private static final String TAG = Log.class.getSimpleName();
    private static final int LL_ERROR = 1;
    private static final int LL_WARN = 2;
    private static final int LL_INFO = 3;
    private static final int LL_DEBUG = 4;
    private static final int LL_TRACE = 5;
    private static Logger logger;

    public static void initialize(Logger logger) {
        Log.logger = logger;
    }

    public static void log(int level, String tag, String message) {
        switch (level) {
            case 1: {
                Log.e(tag, message);
                break;
            }
            case 2: {
                Log.w(tag, message);
                break;
            }
            case 3: {
                Log.i(tag, message);
                break;
            }
            case 4: {
                Log.d(tag, message);
                break;
            }
            case 5: {
                Log.v(tag, message);
                break;
            }
            default: {
                Log.w(TAG, "Unknown log level: " + tag + ", " + message);
            }
        }
    }

    public static void v(String tag, String message) {
        Log.v(tag, message, null);
    }

    public static void d(String tag, String message) {
        Log.d(tag, message, null);
    }

    public static void i(String tag, String message) {
        Log.i(tag, message, null);
    }

    public static void w(String tag, String message) {
        Log.w(tag, message, null);
    }

    public static void e(String tag, String message) {
        Log.e(tag, message, null);
    }

    public static void v(String tag, Throwable t) {
        Log.v(tag, null, t);
    }

    public static void d(String tag, Throwable t) {
        Log.d(tag, null, t);
    }

    public static void i(String tag, Throwable t) {
        Log.i(tag, null, t);
    }

    public static void w(String tag, Throwable t) {
        Log.w(tag, null, t);
    }

    public static void e(String tag, Throwable t) {
        Log.e(tag, null, t);
    }

    public static void v(String tag, String message, Throwable t) {
        if (logger != null) {
            logger.v(tag, message, t);
        } else {
            android.util.Log.v((String)tag, (String)message, (Throwable)t);
        }
    }

    public static void d(String tag, String message, Throwable t) {
        if (logger != null) {
            logger.d(tag, message, t);
        } else {
            android.util.Log.d((String)tag, (String)message, (Throwable)t);
        }
    }

    public static void i(String tag, String message, Throwable t) {
        if (logger != null) {
            logger.i(tag, message, t);
        } else {
            android.util.Log.i((String)tag, (String)message, (Throwable)t);
        }
    }

    public static void w(String tag, String message, Throwable t) {
        if (logger != null) {
            logger.w(tag, message, t);
        } else {
            android.util.Log.w((String)tag, (String)message, (Throwable)t);
        }
    }

    public static void e(String tag, String message, Throwable t) {
        if (logger != null) {
            logger.e(tag, message, t);
        } else {
            android.util.Log.e((String)tag, (String)message, (Throwable)t);
        }
    }

    public static interface Logger {
        public void v(String var1, String var2, Throwable var3);

        public void d(String var1, String var2, Throwable var3);

        public void i(String var1, String var2, Throwable var3);

        public void w(String var1, String var2, Throwable var3);

        public void e(String var1, String var2, Throwable var3);
    }
}

