/*
 * Decompiled with CFR 0.152.
 */
package org.signal.ringrtc;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.util.LinkedList;
import org.signal.ringrtc.BuildInfo;
import org.signal.ringrtc.CallConnection;
import org.signal.ringrtc.CallException;
import org.signal.ringrtc.Log;
import org.signal.ringrtc.WebRtcLogger;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.Loggable;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SSLCertificateVerifier;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;

public class CallConnectionFactory {
    private static final String TAG = CallConnectionFactory.class.getSimpleName();
    private static boolean isInitialized;
    private long nativeCallConnectionFactory;
    @NonNull
    protected Context context;
    @Nullable
    private PeerConnectionFactory peerConnectionFactory;

    public static void initialize(Context applicationContext, Log.Logger logger) {
        try {
            Log.initialize(logger);
            PeerConnectionFactory.InitializationOptions.Builder builder = PeerConnectionFactory.InitializationOptions.builder((Context)applicationContext).setNativeLibraryLoader((NativeLibraryLoader)new NoOpLoader());
            BuildInfo buildInfo = CallConnectionFactory.ringrtcGetBuildInfo();
            if (buildInfo.debug) {
                builder.setInjectableLogger((Loggable)new WebRtcLogger(), Logging.Severity.LS_INFO);
            }
            Log.i(TAG, "CallManager.initialize(): (" + (buildInfo.debug ? "debug" : "release") + " build)");
            PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)builder.createInitializationOptions());
            CallConnectionFactory.ringrtcInitialize();
            isInitialized = true;
            Log.i(TAG, "CallConnectionFactory.initialize() returned");
        }
        catch (UnsatisfiedLinkError e) {
            Log.w(TAG, "Unable to load ringrtc library", e);
        }
        catch (CallException e) {
            Log.w(TAG, "ringrtc library initialization failure", e);
        }
    }

    private static void checkInitializeHasBeenCalled() {
        if (!isInitialized) {
            throw new IllegalStateException("CallConnectionFactory.initialize was not called before creating a CallConnectionFactory.");
        }
    }

    private void checkCallConnectionFactoryExists() {
        if (this.peerConnectionFactory == null || this.nativeCallConnectionFactory == 0L) {
            throw new IllegalStateException("CallConnectionFactory has been disposed.");
        }
    }

    CallConnectionFactory(@NonNull Context context, @NonNull VideoEncoderFactory encoderFactory, @NonNull VideoDecoderFactory decoderFactory) {
        Log.i(TAG, "CallConnectionFactory() called");
        CallConnectionFactory.checkInitializeHasBeenCalled();
        this.context = context;
        this.peerConnectionFactory = PeerConnectionFactory.builder().setOptions((PeerConnectionFactory.Options)new PeerConnectionFactoryOptions()).setVideoEncoderFactory(encoderFactory).setVideoDecoderFactory(decoderFactory).createPeerConnectionFactory();
    }

    @Nullable
    public static CallConnectionFactory createCallConnectionFactory(@NonNull Context context, @NonNull VideoEncoderFactory encoderFactory, @NonNull VideoDecoderFactory decoderFactory) {
        Log.i(TAG, "createCallConnectionFactory() called");
        CallConnectionFactory callConnectionFactory = new CallConnectionFactory(context, encoderFactory, decoderFactory);
        long nativeFactory = callConnectionFactory.peerConnectionFactory.getNativeOwnedFactoryAndThreads();
        long nativeCallConnectionFactory = CallConnectionFactory.ringrtcCreateCallConnectionFactory(nativeFactory);
        if (nativeCallConnectionFactory != 0L) {
            callConnectionFactory.nativeCallConnectionFactory = nativeCallConnectionFactory;
            return callConnectionFactory;
        }
        return null;
    }

    public void dispose() {
        this.checkCallConnectionFactoryExists();
        Log.i(TAG, "CallConnectionFactory.dispose(): calling peerConnectionFactory.dispose()");
        this.peerConnectionFactory.dispose();
        this.peerConnectionFactory = null;
        Log.i(TAG, "CallConnectionFactory.dispose(): calling nativeFreeFactory()");
        CallConnectionFactory.ringrtcFreeFactory(this.nativeCallConnectionFactory);
        this.nativeCallConnectionFactory = 0L;
    }

    @Nullable
    CallConnection createCallConnectionInternal(@NonNull CallConnection.Configuration callConfiguration, @NonNull CallConnection.Observer observer, @NonNull PeerConnection.RTCConfiguration rtcConfig, @NonNull MediaConstraints constraints, @NonNull SSLCertificateVerifier sslCertificateVerifier) throws IOException, CallException {
        Log.i(TAG, "createCallConnectionInternal()");
        this.checkCallConnectionFactoryExists();
        long nativeObserver = CallConnection.createNativeCallConnectionObserver(observer, callConfiguration.callId, callConfiguration.recipient);
        if (nativeObserver == 0L) {
            return null;
        }
        long nativeCallConnection = CallConnectionFactory.ringrtcCreateCallConnection(this.nativeCallConnectionFactory, callConfiguration, nativeObserver, rtcConfig, constraints, sslCertificateVerifier);
        if (nativeCallConnection == 0L) {
            Log.w(TAG, "Unable to create native CallConnection()");
            return null;
        }
        CallConnection callConnection = new CallConnection(new CallConnection.NativeFactory(nativeCallConnection, this, callConfiguration.callId, callConfiguration.recipient));
        return callConnection;
    }

    @Nullable
    public CallConnection createCallConnection(@NonNull CallConnection.Configuration callConfiguration, @NonNull CallConnection.Observer observer) throws IOException, CallException {
        LinkedList iceServers = new LinkedList();
        MediaConstraints constraints = new MediaConstraints();
        PeerConnection.RTCConfiguration configuration = new PeerConnection.RTCConfiguration(iceServers);
        configuration.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        configuration.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        if (callConfiguration.hideIp) {
            configuration.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        constraints.optional.add(new MediaConstraints.KeyValuePair("DtlsSrtpKeyAgreement", "true"));
        return this.createCallConnectionInternal(callConfiguration, observer, configuration, constraints, null);
    }

    public MediaStream createLocalMediaStream(String label) {
        return this.peerConnectionFactory.createLocalMediaStream(label);
    }

    public AudioSource createAudioSource(MediaConstraints constraints) {
        return this.peerConnectionFactory.createAudioSource(constraints);
    }

    public AudioTrack createAudioTrack(String id, AudioSource source) {
        return this.peerConnectionFactory.createAudioTrack(id, source);
    }

    public VideoSource createVideoSource(boolean isScreencast) {
        return this.peerConnectionFactory.createVideoSource(isScreencast);
    }

    public VideoTrack createVideoTrack(String id, VideoSource source) {
        return this.peerConnectionFactory.createVideoTrack(id, source);
    }

    private static native BuildInfo ringrtcGetBuildInfo() throws CallException;

    private static native void ringrtcInitialize() throws CallException;

    private static native long ringrtcCreateCallConnectionFactory(long var0);

    private static native void ringrtcFreeFactory(long var0);

    private static native long ringrtcCreateCallConnection(long var0, CallConnection.Configuration var2, long var3, PeerConnection.RTCConfiguration var5, MediaConstraints var6, SSLCertificateVerifier var7) throws IOException, CallException;

    static {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i(TAG, "Preloading ringrtc_rffi library for SDK: " + Build.VERSION.SDK_INT);
            System.loadLibrary("ringrtc_rffi");
        }
        Log.d(TAG, "Loading ringrtc library");
        System.loadLibrary("ringrtc");
    }

    class PeerConnectionFactoryOptions
    extends PeerConnectionFactory.Options {
        public PeerConnectionFactoryOptions() {
            this.networkIgnoreMask = 16;
        }
    }

    static class NoOpLoader
    implements NativeLibraryLoader {
        public boolean load(String name) {
            return true;
        }
    }
}

