/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.ecc;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "Lorg/signal/libsignal/internal/NativeHandleGuard$SimpleOwner;", "privateKey", "", "<init>", "([B)V", "nativeHandle", "", "(J)V", "release", "", "serialize", "calculateSignature", "message", "calculateAgreement", "other", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getPublicKey", "publicKey", "Companion", "libsignal-client"})
public final class ECPrivateKey
extends NativeHandleGuard.SimpleOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ECPrivateKey(@NotNull byte[] privateKey) throws InvalidKeyException {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this(Native.ECPrivateKey_Deserialize(privateKey));
    }

    public ECPrivateKey(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.ECPrivateKey_Destroy(nativeHandle);
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.guardedMapChecked(Native::ECPrivateKey_Serialize);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMapChecked(...)");
        return byArray;
    }

    @NotNull
    public final byte[] calculateSignature(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] byArray = this.guardedMap(arg_0 -> ECPrivateKey.calculateSignature$lambda$0(message, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMap(...)");
        return byArray;
    }

    @NotNull
    public final byte[] calculateAgreement(@NotNull ECPublicKey other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        byte[] byArray = this.guardedMap(arg_0 -> ECPrivateKey.calculateAgreement$lambda$2(other, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"guardedMap(...)");
        return byArray;
    }

    @JvmName(name="publicKey")
    @NotNull
    public final ECPublicKey publicKey() {
        Long l = this.guardedMapChecked(Native::ECPrivateKey_GetPublicKey);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"guardedMapChecked(...)");
        return new ECPublicKey(((Number)l).longValue());
    }

    private static final byte[] calculateSignature$lambda$0(byte[] $message, long it) {
        return Native.ECPrivateKey_Sign(it, $message);
    }

    private static final byte[] calculateAgreement$lambda$2$lambda$1(long $privateKey, long publicKey) {
        return Native.ECPrivateKey_Agree($privateKey, publicKey);
    }

    private static final byte[] calculateAgreement$lambda$2(ECPublicKey $other, long privateKey) {
        return $other.guardedMap(arg_0 -> ECPrivateKey.calculateAgreement$lambda$2$lambda$1(privateKey, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final ECPrivateKey generate() {
        return Companion.generate();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/signal/libsignal/protocol/ecc/ECPrivateKey$Companion;", "", "<init>", "()V", "generate", "Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "libsignal-client"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ECPrivateKey generate() {
            return new ECPrivateKey(Native.ECPrivateKey_Generate());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

