/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.TokioAsyncContext;

public class CompletableFuture<T>
implements Future<T> {
    private boolean completed;
    private boolean cancelled;
    private T result;
    private Throwable exception;
    private List<ThenApplyCompleter<T>> consumers;
    private final List<ThenApplyCompleter<T>> INVALIDATED_LIST = Collections.emptyList();
    private Optional<TokioAsyncContext> runtime = Optional.empty();
    private Optional<Long> cancellationId = Optional.empty();

    @CalledFromNative
    public CompletableFuture() {
        this.consumers = new ArrayList<ThenApplyCompleter<T>>();
    }

    @CalledFromNative
    void setCancellationId(long cancellationId) {
        this.cancellationId = Optional.of(cancellationId);
    }

    public CompletableFuture<T> makeCancelable(TokioAsyncContext context) {
        this.runtime = Optional.of(context);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        List<ThenApplyCompleter<T>> consumers;
        if (!mayInterruptIfRunning) {
            return false;
        }
        CancellationException throwable = new CancellationException("Future was canceled");
        CompletableFuture completableFuture = this;
        synchronized (completableFuture) {
            if (this.completed || this.cancelled) {
                return false;
            }
            if (!this.runtime.isPresent() || !this.cancellationId.isPresent()) {
                return false;
            }
            this.runtime.get().guardedRun(nativeContextHandle -> Native.TokioAsyncContext_cancel(nativeContextHandle, this.cancellationId.get()));
            consumers = this.consumers;
            this.completeExceptionally(throwable, false);
            this.cancelled = true;
        }
        for (ThenApplyCompleter thenApplyCompleter : consumers) {
            thenApplyCompleter.completeExceptionally.accept(throwable);
        }
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledFromNative
    public boolean complete(T result) {
        List<ThenApplyCompleter<T>> consumers;
        CompletableFuture completableFuture = this;
        synchronized (completableFuture) {
            if (this.completed || this.cancelled) {
                return false;
            }
            this.result = result;
            this.completed = true;
            consumers = this.consumers;
            this.consumers = this.INVALIDATED_LIST;
            this.notifyAll();
        }
        for (ThenApplyCompleter thenApplyCompleter : consumers) {
            thenApplyCompleter.complete.accept(result);
        }
        return true;
    }

    @CalledFromNative
    public boolean completeExceptionally(Throwable throwable) {
        return this.completeExceptionally(throwable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeExceptionally(Throwable throwable, boolean notifyConsumers) {
        List<ThenApplyCompleter<T>> consumers;
        CompletableFuture completableFuture = this;
        synchronized (completableFuture) {
            if (this.completed || this.cancelled) {
                return false;
            }
            if (throwable == null) {
                throwable = new AssertionError((Object)"Future failed, but no exception provided");
            }
            this.exception = throwable;
            this.completed = true;
            consumers = this.consumers;
            this.consumers = this.INVALIDATED_LIST;
            this.notifyAll();
        }
        if (notifyConsumers) {
            for (ThenApplyCompleter thenApplyCompleter : consumers) {
                thenApplyCompleter.completeExceptionally.accept((Throwable)throwable);
            }
        }
        return true;
    }

    @Override
    public synchronized T get() throws CancellationException, ExecutionException, InterruptedException {
        while (!this.completed) {
            this.wait();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        long deadlineMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.completed) {
            long remainingMillis = deadlineMillis - System.currentTimeMillis();
            if (remainingMillis <= 0L) {
                throw new TimeoutException();
            }
            this.wait(remainingMillis);
        }
        return this.get();
    }

    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.addChainedFuture((future, value) -> {
            Object output;
            try {
                output = fn.apply(value);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return;
            }
            future.complete(output);
        }, CompletableFuture::completeExceptionally);
    }

    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletableFuture<U>> fn) {
        return this.addChainedFuture((future, value) -> {
            CompletableFuture output;
            try {
                output = (CompletableFuture)fn.apply(value);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return;
            }
            output.addCompleter(new ThenApplyCompleter<Object>(future::complete, future::completeExceptionally));
        }, CompletableFuture::completeExceptionally);
    }

    public CompletableFuture<T> whenComplete(BiConsumer<? super T, Throwable> fn) {
        return this.addChainedFuture((future, value) -> {
            try {
                fn.accept(value, null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                return;
            }
            future.complete(value);
        }, (future, throwable) -> {
            try {
                fn.accept((Object)null, (Throwable)throwable);
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)throwable);
                return;
            }
            future.completeExceptionally((Throwable)throwable);
        });
    }

    private <U> CompletableFuture<U> addChainedFuture(BiConsumer<CompletableFuture<U>, T> complete, BiConsumer<CompletableFuture<U>, Throwable> completeExceptionally) {
        CompletableFuture future = new CompletableFuture();
        if (this.runtime.isPresent() && this.cancellationId.isPresent()) {
            future.setCancellationId(this.cancellationId.get());
            future.makeCancelable(this.runtime.get());
        }
        ThenApplyCompleter<Object> completer = new ThenApplyCompleter<Object>(value -> complete.accept(future, value), exception -> completeExceptionally.accept((CompletableFuture)future, (Throwable)exception));
        this.addCompleter(completer);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompleter(ThenApplyCompleter<T> completer) {
        Throwable exception;
        T result;
        CompletableFuture completableFuture = this;
        synchronized (completableFuture) {
            if (!this.completed) {
                this.consumers.add(completer);
                return;
            }
            result = this.result;
            exception = this.exception;
        }
        if (exception != null) {
            completer.completeExceptionally.accept(exception);
        } else {
            completer.complete.accept(result);
        }
    }

    private static class ThenApplyCompleter<T> {
        private Consumer<? super T> complete;
        private Consumer<Throwable> completeExceptionally;

        private ThenApplyCompleter(Consumer<? super T> complete, Consumer<Throwable> completeExceptionally) {
            this.complete = complete;
            this.completeExceptionally = completeExceptionally;
        }
    }
}

