/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.kem;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;

public class KEMSecretKey
extends NativeHandleGuard.SimpleOwner {
    public KEMSecretKey(byte[] privateKey) throws InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.KyberSecretKey_Deserialize(privateKey)));
    }

    public KEMSecretKey(long nativeHandle) {
        super(KEMSecretKey.throwIfNull(nativeHandle));
    }

    private static long throwIfNull(long handle) {
        if (handle == 0L) {
            throw new NullPointerException();
        }
        return handle;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.KyberSecretKey_Destroy(nativeHandle);
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::KyberSecretKey_Serialize));
    }
}

