/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import java.util.Optional;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class ServerCertificate
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.ServerCertificate_Destroy(nativeHandle);
    }

    public ServerCertificate(long nativeHandle) {
        super(nativeHandle);
    }

    public ServerCertificate(byte[] serialized) throws InvalidCertificateException {
        super(ServerCertificate.createNativeFrom(serialized));
    }

    private static long createNativeFrom(byte[] serialized) throws InvalidCertificateException {
        try {
            return Native.ServerCertificate_Deserialize(serialized);
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public ServerCertificate(ECPrivateKey trustRoot, int keyId, ECPublicKey key) {
        super(FilterExceptions.filterExceptions(() -> key.guardedMapChecked(serverPublicHandle -> trustRoot.guardedMapChecked(trustRootHandle -> Native.ServerCertificate_New(keyId, serverPublicHandle, trustRootHandle)))));
    }

    public int getKeyId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ServerCertificate_GetKeyId));
    }

    public ECPublicKey getKey() {
        return new ECPublicKey(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ServerCertificate_GetKey)));
    }

    public byte[] getSerialized() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ServerCertificate_GetSerialized));
    }

    public byte[] getCertificate() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ServerCertificate_GetCertificate));
    }

    public byte[] getSignature() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::ServerCertificate_GetSignature));
    }

    /*
     * Exception decompiling
     */
    public SenderCertificate issue(ECPrivateKey signingKey, String senderUuid, Optional<String> senderE164, int senderDeviceId, ECPublicKey senderIdentityKey, long expiration) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SenderCertificate issue(ECPrivateKey signingKey, ServiceId sender, Optional<String> senderE164, int senderDeviceId, ECPublicKey senderIdentityKey, long expiration) {
        return this.issue(signingKey, sender.toString(), senderE164, senderDeviceId, senderIdentityKey, expiration);
    }

    private static /* synthetic */ long lambda$issue$8(String senderUuid, Optional senderE164, int senderDeviceId, NativeHandleGuard identityGuard, long expiration, NativeHandleGuard serverCertificateGuard, NativeHandleGuard serverPrivateGuard) throws Exception {
        return Native.SenderCertificate_New(senderUuid, senderE164.orElse(null), senderDeviceId, identityGuard.nativeHandle(), expiration, serverCertificateGuard.nativeHandle(), serverPrivateGuard.nativeHandle());
    }
}

