/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.TokioAsyncContext;

public interface ChatConnectionListener {
    public void onIncomingMessage(ChatConnection var1, byte[] var2, long var3, ServerMessageAck var5);

    default public void onQueueEmpty(ChatConnection chat) {
    }

    default public void onConnectionInterrupted(ChatConnection chat, ChatServiceException disconnectReason) {
    }

    public static class ServerMessageAck
    extends NativeHandleGuard.SimpleOwner {
        private final TokioAsyncContext asyncContext;

        ServerMessageAck(TokioAsyncContext context, long nativeHandle) {
            super(nativeHandle);
            this.asyncContext = context;
        }

        @Override
        protected void release(long nativeHandle) {
            Native.ServerMessageAck_Destroy(nativeHandle);
        }

        public CompletableFuture<Void> send() {
            return this.asyncContext.guardedMap(asyncContextHandle -> this.guardedMap(ackHandle -> Native.ServerMessageAck_Send(asyncContextHandle, ackHandle)));
        }
    }
}

