/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.function.Function;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.ChatListener;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.IpType;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.TokioAsyncContext;
import org.signal.libsignal.net.internal.BridgeChatListener;

public abstract class ChatService
extends NativeHandleGuard.SimpleOwner {
    private final TokioAsyncContext tokioAsyncContext;
    protected final ChatListener chatListener;

    ChatService(TokioAsyncContext tokioAsyncContext, Network.ConnectionManager connectionManager, Function<Long, Long> chatServiceCreateWrapper, ChatListener chatListener) {
        super(connectionManager.guardedMap(chatServiceCreateWrapper::apply));
        this.tokioAsyncContext = tokioAsyncContext;
        this.chatListener = chatListener;
        if (chatListener != null) {
            ListenerBridge listenerBridge = new ListenerBridge(this);
            tokioAsyncContext.guardedRun(asyncContextHandle -> this.guardedRun(chatServiceHandle -> this.setListenerWrapper(asyncContextHandle, chatServiceHandle, listenerBridge)));
        }
    }

    public CompletableFuture<Void> disconnect() {
        return this.tokioAsyncContext.guardedMap(asyncContextHandle -> this.guardedMap(chatServiceHandle -> this.disconnectWrapper(asyncContextHandle, chatServiceHandle)));
    }

    public CompletableFuture<DebugInfo> connect() {
        return this.tokioAsyncContext.guardedMap(asyncContextHandle -> this.guardedMap(chatServiceHandle -> this.connectWrapper(asyncContextHandle, chatServiceHandle).thenApply(o -> (DebugInfo)o)));
    }

    /*
     * Exception decompiling
     */
    public CompletableFuture<Response> send(Request req) throws MalformedURLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public CompletableFuture<ResponseAndDebugInfo> sendAndDebug(Request req) throws MalformedURLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract CompletableFuture disconnectWrapper(long var1, long var3);

    protected abstract CompletableFuture<Object> sendWrapper(long var1, long var3, long var5, int var7);

    protected abstract CompletableFuture<Object> connectWrapper(long var1, long var3);

    protected abstract CompletableFuture<Object> sendAndDebugWrapper(long var1, long var3, long var5, int var7);

    protected abstract void setListenerWrapper(long var1, long var3, BridgeChatListener var5);

    static InternalRequest buildInternalRequest(Request req) throws MalformedURLException {
        InternalRequest result = new InternalRequest(req.method(), req.pathAndQuery(), req.body());
        req.headers().forEach(result::addHeader);
        return result;
    }

    private static /* synthetic */ ResponseAndDebugInfo lambda$sendAndDebug$8(Object o) {
        return (ResponseAndDebugInfo)o;
    }

    private static /* synthetic */ Response lambda$send$7(Object o) {
        return (Response)o;
    }

    private static final class ListenerBridge
    implements BridgeChatListener {
        private final WeakReference<ChatService> chat;

        ListenerBridge(ChatService chat) {
            this.chat = new WeakReference<ChatService>(chat);
        }

        @Override
        public void onIncomingMessage(byte[] envelope, long serverDeliveryTimestamp, long sendAckHandle) {
            ChatService chat = (ChatService)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            chat.chatListener.onIncomingMessage(chat, envelope, serverDeliveryTimestamp, new ChatListener.ServerMessageAck(chat.tokioAsyncContext, sendAckHandle));
        }

        @Override
        public void onQueueEmpty() {
            ChatService chat = (ChatService)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            chat.chatListener.onQueueEmpty(chat);
        }

        @Override
        public void onConnectionInterrupted(Throwable disconnectReason) {
            ChatService chat = (ChatService)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            ChatServiceException disconnectReasonChatServiceException = disconnectReason == null ? null : (disconnectReason instanceof ChatServiceException ? (ChatServiceException)disconnectReason : new ChatServiceException("OtherDisconnectReason", disconnectReason));
            chat.chatListener.onConnectionInterrupted(chat, disconnectReasonChatServiceException);
        }
    }

    public record Request(String method, String pathAndQuery, Map<String, String> headers, byte[] body, int timeoutMillis) {
    }

    static class InternalRequest
    extends NativeHandleGuard.SimpleOwner {
        InternalRequest(String method, String pathAndQuery, byte[] body) throws MalformedURLException {
            super(FilterExceptions.filterExceptions(MalformedURLException.class, () -> Native.HttpRequest_new(method, pathAndQuery, body)));
        }

        @Override
        protected void release(long nativeHandle) {
            Native.HttpRequest_Destroy(nativeHandle);
        }

        public void addHeader(String name, String value) {
            this.guardedRun(h -> Native.HttpRequest_add_header(h, name, value));
        }
    }

    public record ResponseAndDebugInfo(Response response, DebugInfo debugInfo) {
    }

    public record Response(int status, String message, Map<String, String> headers, byte[] body) {
    }

    public record DebugInfo(IpType ipType, int durationMs, String connectionInfo) {
        @CalledFromNative
        DebugInfo(byte ipTypeCode, int durationMs, String connectionInfo) {
            this(IpType.values()[ipTypeCode], durationMs, connectionInfo);
        }
    }
}

