/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.ChatService;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.TokioAsyncContext;

public interface ChatListener {
    public void onIncomingMessage(ChatService var1, byte[] var2, long var3, ServerMessageAck var5);

    default public void onQueueEmpty(ChatService chat) {
    }

    default public void onConnectionInterrupted(ChatService chat, ChatServiceException disconnectReason) {
    }

    public static class ServerMessageAck
    extends NativeHandleGuard.SimpleOwner {
        private final TokioAsyncContext asyncContext;

        ServerMessageAck(TokioAsyncContext context, long nativeHandle) {
            super(nativeHandle);
            this.asyncContext = context;
        }

        @Override
        protected void release(long nativeHandle) {
            Native.ServerMessageAck_Destroy(nativeHandle);
        }

        public CompletableFuture<Void> send() {
            return this.asyncContext.guardedMap(asyncContextHandle -> this.guardedMap(ackHandle -> Native.ServerMessageAck_Send(asyncContextHandle, ackHandle)));
        }
    }
}

