/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Map;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.ChatService;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.TokioAsyncContext;
import org.signal.libsignal.net.internal.BridgeChatListener;

public abstract class ChatConnection
extends NativeHandleGuard.SimpleOwner {
    private final TokioAsyncContext tokioAsyncContext;
    private final ChatConnectionListener chatListener;

    protected ChatConnection(TokioAsyncContext tokioAsyncContext, long nativeHandle, ChatConnectionListener chatListener) {
        super(nativeHandle);
        this.tokioAsyncContext = tokioAsyncContext;
        this.chatListener = chatListener;
    }

    public void start() {
        ListenerBridge bridgedChatListener = new ListenerBridge(this);
        this.guardedRun(nativeChatConnectionHandle -> this.startWrapper(nativeChatConnectionHandle, bridgedChatListener));
    }

    public CompletableFuture<Void> disconnect() {
        return this.tokioAsyncContext.guardedMap(asyncContextHandle -> this.guardedMap(chatServiceHandle -> this.disconnectWrapper(asyncContextHandle, chatServiceHandle)));
    }

    /*
     * Exception decompiling
     */
    public CompletableFuture<Response> send(Request req) throws MalformedURLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract CompletableFuture disconnectWrapper(long var1, long var3);

    protected abstract CompletableFuture<Object> sendWrapper(long var1, long var3, long var5, int var7);

    protected abstract void startWrapper(long var1, BridgeChatListener var3);

    static InternalRequest buildInternalRequest(Request req) throws MalformedURLException {
        InternalRequest result = new InternalRequest(req.method(), req.pathAndQuery(), req.body());
        req.headers().forEach(result::addHeader);
        return result;
    }

    protected static class ListenerBridge
    implements BridgeChatListener {
        protected WeakReference<ChatConnection> chat;

        protected ListenerBridge(ChatConnection chat) {
            this.chat = new WeakReference<ChatConnection>(chat);
        }

        @Override
        public void onIncomingMessage(byte[] envelope, long serverDeliveryTimestamp, long sendAckHandle) {
            ChatConnection chat = (ChatConnection)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            chat.chatListener.onIncomingMessage(chat, envelope, serverDeliveryTimestamp, new ChatConnectionListener.ServerMessageAck(chat.tokioAsyncContext, sendAckHandle));
        }

        @Override
        public void onQueueEmpty() {
            ChatConnection chat = (ChatConnection)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            chat.chatListener.onQueueEmpty(chat);
        }

        @Override
        public void onConnectionInterrupted(Throwable disconnectReason) {
            ChatConnection chat = (ChatConnection)this.chat.get();
            if (chat == null) {
                return;
            }
            if (chat.chatListener == null) {
                return;
            }
            ChatServiceException disconnectReasonChatServiceException = disconnectReason == null ? null : (disconnectReason instanceof ChatServiceException ? (ChatServiceException)disconnectReason : new ChatServiceException("OtherDisconnectReason", disconnectReason));
            chat.chatListener.onConnectionInterrupted(chat, disconnectReasonChatServiceException);
        }
    }

    public record Request(String method, String pathAndQuery, Map<String, String> headers, byte[] body, int timeoutMillis) {
    }

    static class InternalRequest
    extends NativeHandleGuard.SimpleOwner {
        InternalRequest(String method, String pathAndQuery, byte[] body) throws MalformedURLException {
            super(FilterExceptions.filterExceptions(MalformedURLException.class, () -> Native.HttpRequest_new(method, pathAndQuery, body)));
        }

        @Override
        protected void release(long nativeHandle) {
            Native.HttpRequest_Destroy(nativeHandle);
        }

        public void addHeader(String name, String value) {
            this.guardedRun(h -> Native.HttpRequest_add_header(h, name, value));
        }
    }

    public record Response(int status, String message, Map<String, String> headers, byte[] body) {
        private static Response from(Object o) {
            ChatService.Response r = (ChatService.Response)o;
            return new Response(r.status(), r.message(), r.headers(), r.body());
        }
    }
}

