/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.keytrans;

import java.util.Optional;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.keytrans.Store;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ServiceId;

public class SearchResult
extends NativeHandleGuard.SimpleOwner {
    public SearchResult(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.SearchResult_Destroy(nativeHandle);
    }

    public IdentityKey getAciIdentityKey() {
        long handle = this.guardedMap(Native::SearchResult_GetAciIdentityKey);
        return new IdentityKey(handle);
    }

    public Optional<ServiceId.Aci> getAciForE164() {
        byte[] aciBytes = this.guardedMap(Native::SearchResult_GetAciForE164);
        try {
            return Optional.ofNullable(aciBytes == null ? null : ServiceId.Aci.parseFromFixedWidthBinary(aciBytes));
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            throw new AssertionError("Invalid serialized ACI", ex);
        }
    }

    public Optional<ServiceId.Aci> getAciForUsernameHash() {
        byte[] aciBytes = this.guardedMap(Native::SearchResult_GetAciForUsernameHash);
        try {
            return Optional.ofNullable(aciBytes == null ? null : ServiceId.Aci.parseFromFixedWidthBinary(aciBytes));
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            throw new AssertionError("Invalid serialized ACI", ex);
        }
    }

    void updateStore(ServiceId.Aci aci, Store store) {
        byte[] accountData = this.guardedMap(Native::SearchResult_GetAccountData);
        if (accountData != null) {
            store.setAccountData(aci, accountData);
        }
    }
}

