/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.kem;

import java.util.Arrays;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;

public class KEMPublicKey
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    public KEMPublicKey(byte[] serialized, int offset) throws InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.KyberPublicKey_DeserializeWithOffset(serialized, offset));
    }

    public KEMPublicKey(byte[] serialized) throws InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.KyberPublicKey_DeserializeWithOffset(serialized, 0));
    }

    public KEMPublicKey(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new NullPointerException();
        }
        this.unsafeHandle = nativeHandle;
    }

    protected void finalize() {
        Native.KyberPublicKey_Destroy(this.unsafeHandle);
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.KyberPublicKey_Serialize(guard.nativeHandle()));
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof KEMPublicKey)) {
            return false;
        }
        try (NativeHandleGuard thisGuard = new NativeHandleGuard(this);){
            NativeHandleGuard thatGuard = new NativeHandleGuard((KEMPublicKey)other);
            try {
                boolean bl = Native.KyberPublicKey_Equals(thisGuard.nativeHandle(), thatGuard.nativeHandle());
                thatGuard.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    thatGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.serialize());
    }
}

