/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.groupsend;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.groupsend.GroupSendCredentialPresentation;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GroupSendCredential
extends ByteArray {
    public GroupSendCredential(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.GroupSendCredential_CheckValidContents(contents);
    }

    public GroupSendCredentialPresentation present(ServerPublicParams serverParams) {
        return this.present(serverParams, new SecureRandom());
    }

    public GroupSendCredentialPresentation present(ServerPublicParams serverParams, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.GroupSendCredential_PresentDeterministic(this.getInternalContentsForJNI(), serverParams.getInternalContentsForJNI(), random);
        try {
            return new GroupSendCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

