/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.fingerprint;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.fingerprint.DisplayableFingerprint;
import org.signal.libsignal.protocol.fingerprint.Fingerprint;
import org.signal.libsignal.protocol.fingerprint.FingerprintGenerator;
import org.signal.libsignal.protocol.fingerprint.ScannableFingerprint;

public class NumericFingerprintGenerator
implements FingerprintGenerator {
    private final int iterations;

    public NumericFingerprintGenerator(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Fingerprint createFor(int version, byte[] localStableIdentifier, IdentityKey localIdentityKey, byte[] remoteStableIdentifier, IdentityKey remoteIdentityKey) {
        long handle = Native.NumericFingerprintGenerator_New(this.iterations, version, localStableIdentifier, localIdentityKey.serialize(), remoteStableIdentifier, remoteIdentityKey.serialize());
        DisplayableFingerprint displayableFingerprint = new DisplayableFingerprint(Native.NumericFingerprintGenerator_GetDisplayString(handle));
        ScannableFingerprint scannableFingerprint = new ScannableFingerprint(Native.NumericFingerprintGenerator_GetScannableEncoding(handle));
        Native.NumericFingerprintGenerator_Destroy(handle);
        return new Fingerprint(displayableFingerprint, scannableFingerprint);
    }
}

