/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.CdsiLookup;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;

public class Network {
    private TokioAsyncContext tokioAsyncContext = new TokioAsyncContext();
    private ConnectionManager connectionManager;

    public Network(Environment env) {
        this.connectionManager = new ConnectionManager(env);
    }

    public CompletableFuture<CdsiLookupResponse> cdsiLookup(String username, String password, CdsiLookupRequest request, Duration timeout, Consumer<byte[]> tokenConsumer) throws IOException, InterruptedException, ExecutionException {
        return CdsiLookup.start(this, username, password, request, timeout).thenCompose(lookup -> {
            tokenConsumer.accept(lookup.getToken());
            return lookup.complete();
        });
    }

    TokioAsyncContext getAsyncContext() {
        return this.tokioAsyncContext;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    class ConnectionManager
    implements NativeHandleGuard.Owner {
        private long nativeHandle;

        private ConnectionManager(Environment env) {
            this.nativeHandle = Native.ConnectionManager_new(env.value);
        }

        @Override
        public long unsafeNativeHandleWithoutGuard() {
            return this.nativeHandle;
        }

        protected void finalize() {
            Native.ConnectionManager_Destroy(this.nativeHandle);
        }
    }

    class TokioAsyncContext
    implements NativeHandleGuard.Owner {
        private long nativeHandle = Native.TokioAsyncContext_new();

        private TokioAsyncContext() {
        }

        @Override
        public long unsafeNativeHandleWithoutGuard() {
            return this.nativeHandle;
        }

        protected void finalize() {
            Native.TokioAsyncContext_Destroy(this.nativeHandle);
        }
    }

    public static enum Environment {
        STAGING(0),
        PRODUCTION(1);

        private final int value;

        private Environment(int value) {
            this.value = value;
        }
    }
}

