/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.protocol;

import java.util.Optional;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.message.CiphertextMessage;

public class UnidentifiedSenderMessageContent
implements NativeHandleGuard.Owner {
    public static final int CONTENT_HINT_DEFAULT = 0;
    public static final int CONTENT_HINT_RESENDABLE = 1;
    public static final int CONTENT_HINT_IMPLICIT = 2;
    private final long unsafeHandle;

    protected void finalize() {
        Native.UnidentifiedSenderMessageContent_Destroy(this.unsafeHandle);
    }

    public UnidentifiedSenderMessageContent(long nativeHandle) {
        this.unsafeHandle = nativeHandle;
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public UnidentifiedSenderMessageContent(byte[] serialized) throws InvalidMetadataMessageException, InvalidCertificateException {
        try {
            this.unsafeHandle = Native.UnidentifiedSenderMessageContent_Deserialize(serialized);
        }
        catch (Exception e) {
            throw new InvalidMetadataMessageException(e);
        }
    }

    public UnidentifiedSenderMessageContent(CiphertextMessage message, SenderCertificate senderCertificate, int contentHint, Optional<byte[]> groupId) {
        try (NativeHandleGuard certificateGuard = new NativeHandleGuard(senderCertificate);){
            this.unsafeHandle = Native.UnidentifiedSenderMessageContent_New(message, certificateGuard.nativeHandle(), contentHint, groupId.orElse(null));
        }
    }

    public int getType() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.UnidentifiedSenderMessageContent_GetMsgType(guard.nativeHandle());
            return n;
        }
    }

    public SenderCertificate getSenderCertificate() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            SenderCertificate senderCertificate = new SenderCertificate(Native.UnidentifiedSenderMessageContent_GetSenderCert(guard.nativeHandle()));
            return senderCertificate;
        }
    }

    public byte[] getContent() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.UnidentifiedSenderMessageContent_GetContents(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getSerialized() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.UnidentifiedSenderMessageContent_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    public int getContentHint() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.UnidentifiedSenderMessageContent_GetContentHint(guard.nativeHandle());
            return n;
        }
    }

    public Optional<byte[]> getGroupId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Optional<byte[]> optional = Optional.ofNullable(Native.UnidentifiedSenderMessageContent_GetGroupId(guard.nativeHandle()));
            return optional;
        }
    }
}

