/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.NotarySignature;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class ServerSecretParams
extends ByteArray {
    public static ServerSecretParams generate() {
        return ServerSecretParams.generate(new SecureRandom());
    }

    public static ServerSecretParams generate(SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerSecretParams_GenerateDeterministic(random);
        try {
            return new ServerSecretParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ServerSecretParams(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.ServerSecretParams_CheckValidContents(contents);
    }

    public ServerPublicParams getPublicParams() {
        byte[] newContents = Native.ServerSecretParams_GetPublicParams(this.contents);
        try {
            return new ServerPublicParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public NotarySignature sign(byte[] message) {
        return this.sign(new SecureRandom(), message);
    }

    public NotarySignature sign(SecureRandom secureRandom, byte[] message) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.ServerSecretParams_SignDeterministic(this.contents, random, message);
        try {
            return new NotarySignature(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

