/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup;

import java.security.SecureRandom;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class GenericServerSecretParams
extends ByteArray {
    public static GenericServerSecretParams generate() {
        return GenericServerSecretParams.generate(new SecureRandom());
    }

    public static GenericServerSecretParams generate(SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.GenericServerSecretParams_GenerateDeterministic(random);
        try {
            return new GenericServerSecretParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public GenericServerSecretParams(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.GenericServerSecretParams_CheckValidContents(contents);
    }

    public GenericServerPublicParams getPublicParams() {
        byte[] newContents = Native.GenericServerSecretParams_GetPublicParams(this.contents);
        try {
            return new GenericServerPublicParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

