/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.metadata.certificate;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class ServerCertificate
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.ServerCertificate_Destroy(this.unsafeHandle);
    }

    public ServerCertificate(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public ServerCertificate(byte[] serialized) throws InvalidCertificateException {
        try {
            this.unsafeHandle = Native.ServerCertificate_Deserialize(serialized);
        }
        catch (Exception e) {
            throw new InvalidCertificateException(e);
        }
    }

    public int getKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.ServerCertificate_GetKeyId(guard.nativeHandle());
            return n;
        }
    }

    public ECPublicKey getKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(Native.ServerCertificate_GetKey(guard.nativeHandle()));
            return eCPublicKey;
        }
    }

    public byte[] getSerialized() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.ServerCertificate_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getCertificate() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.ServerCertificate_GetCertificate(guard.nativeHandle());
            return byArray;
        }
    }

    public byte[] getSignature() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.ServerCertificate_GetSignature(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

