/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.hsmenclave;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;

public class HsmEnclaveClient
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    public HsmEnclaveClient(byte[] public_key, List<byte[]> code_hashes) {
        ByteArrayOutputStream concatHashes = new ByteArrayOutputStream();
        for (byte[] hash : code_hashes) {
            if (hash.length != 32) {
                throw new IllegalArgumentException("code hash length must be 32");
            }
            try {
                concatHashes.write(hash);
            }
            catch (IOException e) {
                throw new AssertionError("writing to ByteArrayOutputStream failed", e);
            }
        }
        this.unsafeHandle = Native.HsmEnclaveClient_New(public_key, concatHashes.toByteArray());
    }

    protected void finalize() {
        Native.HsmEnclaveClient_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public byte[] initialRequest() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.HsmEnclaveClient_InitialRequest(guard.nativeHandle());
            return byArray;
        }
    }

    public void completeHandshake(byte[] handshakeResponse) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            Native.HsmEnclaveClient_CompleteHandshake(guard.nativeHandle(), handshakeResponse);
        }
    }

    public byte[] establishedSend(byte[] plaintextToSend) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.HsmEnclaveClient_EstablishedSend(guard.nativeHandle(), plaintextToSend);
            return byArray;
        }
    }

    public byte[] establishedRecv(byte[] receivedCiphertext) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.HsmEnclaveClient_EstablishedRecv(guard.nativeHandle(), receivedCiphertext);
            return byArray;
        }
    }
}

