/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.calllinks.CallLinkPublicParams;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CallLinkSecretParams
extends ByteArray {
    public static CallLinkSecretParams deriveFromRootKey(byte[] rootKey) {
        byte[] newContents = Native.CallLinkSecretParams_DeriveFromRootKey(rootKey);
        try {
            return new CallLinkSecretParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public CallLinkSecretParams(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.CallLinkSecretParams_CheckValidContents(contents);
    }

    public CallLinkPublicParams getPublicParams() {
        byte[] newContents = Native.CallLinkSecretParams_GetPublicParams(this.contents);
        try {
            return new CallLinkPublicParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ServiceId.Aci decryptUserId(UuidCiphertext ciphertext) throws VerificationFailedException {
        try {
            return ServiceId.Aci.parseFromFixedWidthBinary(Native.CallLinkSecretParams_DecryptUserId(this.getInternalContentsForJNI(), ciphertext.getInternalContentsForJNI()));
        }
        catch (ServiceId.InvalidServiceIdException e) {
            throw new VerificationFailedException();
        }
    }
}

