/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import java.security.SecureRandom;
import java.time.Instant;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.GenericServerSecretParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.calllinks.CallLinkAuthCredential;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CallLinkAuthCredentialResponse
extends ByteArray {
    public CallLinkAuthCredentialResponse(byte[] contents) throws InvalidInputException {
        super(contents);
        Native.CallLinkAuthCredentialResponse_CheckValidContents(contents);
    }

    public static CallLinkAuthCredentialResponse issueCredential(ServiceId.Aci userId, Instant redemptionTime, GenericServerSecretParams params) {
        return CallLinkAuthCredentialResponse.issueCredential(userId, redemptionTime, params, new SecureRandom());
    }

    public static CallLinkAuthCredentialResponse issueCredential(ServiceId.Aci userId, Instant redemptionTime, GenericServerSecretParams params, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.CallLinkAuthCredentialResponse_IssueDeterministic(userId.toServiceIdFixedWidthBinary(), redemptionTime.getEpochSecond(), params.getInternalContentsForJNI(), random);
        try {
            return new CallLinkAuthCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public CallLinkAuthCredential receive(ServiceId.Aci userId, Instant redemptionTime, GenericServerPublicParams params) throws VerificationFailedException {
        byte[] newContents = Native.CallLinkAuthCredentialResponse_Receive(this.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary(), redemptionTime.getEpochSecond(), params.getInternalContentsForJNI());
        try {
            return new CallLinkAuthCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

