/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.Optional;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.SignalMessage;

public class PreKeySignalMessage
implements CiphertextMessage,
NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.PreKeySignalMessage_Destroy(this.unsafeHandle);
    }

    public PreKeySignalMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, LegacyMessageException, InvalidKeyException {
        this.unsafeHandle = Native.PreKeySignalMessage_Deserialize(serialized);
    }

    public PreKeySignalMessage(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public int getMessageVersion() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeySignalMessage_GetVersion(guard.nativeHandle());
            return n;
        }
    }

    public IdentityKey getIdentityKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            IdentityKey identityKey = new IdentityKey(Native.PreKeySignalMessage_GetIdentityKey(guard.nativeHandle()));
            return identityKey;
        }
    }

    public int getRegistrationId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeySignalMessage_GetRegistrationId(guard.nativeHandle());
            return n;
        }
    }

    public Optional<Integer> getPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int pre_key = Native.PreKeySignalMessage_GetPreKeyId(guard.nativeHandle());
            if (pre_key < 0) {
                Optional<Integer> optional = Optional.empty();
                return optional;
            }
            Optional<Integer> optional = Optional.of(pre_key);
            return optional;
        }
    }

    public int getSignedPreKeyId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.PreKeySignalMessage_GetSignedPreKeyId(guard.nativeHandle());
            return n;
        }
    }

    public ECPublicKey getBaseKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(Native.PreKeySignalMessage_GetBaseKey(guard.nativeHandle()));
            return eCPublicKey;
        }
    }

    public SignalMessage getWhisperMessage() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            SignalMessage signalMessage = new SignalMessage(Native.PreKeySignalMessage_GetSignalMessage(guard.nativeHandle()));
            return signalMessage;
        }
    }

    @Override
    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = Native.PreKeySignalMessage_GetSerialized(guard.nativeHandle());
            return byArray;
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

